/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.widget;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ListBox;
import java.util.List;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class SpaceSelector
extends ListBox {
    private String wiki;
    private final WikiServiceAsync wikiService;

    public SpaceSelector(WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
    }

    public void refreshList(final String currentSpace, final AsyncCallback<List<String>> cb) {
        this.clear();
        this.wikiService.getSpaceNames(this.wiki, new AsyncCallback<List<String>>(){

            public void onFailure(Throwable caught) {
                throw new RuntimeException(caught.getMessage());
            }

            public void onSuccess(List<String> result) {
                for (String s : result) {
                    SpaceSelector.this.addItem(s);
                    if (!s.equals(currentSpace)) continue;
                    SpaceSelector.this.setSelectedIndex(SpaceSelector.this.getItemCount() - 1);
                }
                if (cb != null) {
                    cb.onSuccess(result);
                }
            }
        });
    }

    public void refreshList(String currentSpace) {
        this.refreshList(currentSpace, null);
    }

    public String getSelectedSpace() {
        if (this.getSelectedIndex() >= 0) {
            return this.getItemText(this.getSelectedIndex());
        }
        return null;
    }

    public void setSelectedSpace(String space) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!this.getItemText(i).equals(space)) continue;
            this.setSelectedIndex(i);
        }
    }

    public String getWiki() {
        return this.wiki;
    }

    public void setWiki(String wiki) {
        this.wiki = wiki;
    }
}

