/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.widget;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ListBox;
import java.util.List;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class WikiSelector
extends ListBox {
    private final WikiServiceAsync wikiService;

    public WikiSelector(WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
    }

    public void refreshList(final String currentWiki, final AsyncCallback<List<String>> cb) {
        this.clear();
        this.wikiService.getVirtualWikiNames(new AsyncCallback<List<String>>(){

            public void onFailure(Throwable caught) {
                throw new RuntimeException(caught.getMessage());
            }

            public void onSuccess(List<String> result) {
                for (String wiki : result) {
                    WikiSelector.this.addItem(wiki);
                    if (!wiki.equals(currentWiki)) continue;
                    WikiSelector.this.setSelectedIndex(WikiSelector.this.getItemCount() - 1);
                }
                if (cb != null) {
                    cb.onSuccess(result);
                }
            }
        });
    }

    public void refreshList(String currentWiki) {
        this.refreshList(currentWiki, null);
    }

    public String getSelectedWiki() {
        if (this.getSelectedIndex() >= 0) {
            return this.getItemText(this.getSelectedIndex());
        }
        return null;
    }

    public void setSelectedWiki(String wiki) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!this.getItemText(i).equals(wiki)) continue;
            this.setSelectedIndex(i);
        }
    }
}

