/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.wysiwyg.client.PlainTextEditor;
import org.xwiki.gwt.wysiwyg.client.RichTextEditor;
import org.xwiki.gwt.wysiwyg.client.RichTextEditorController;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.WysiwygEditorConfig;
import org.xwiki.gwt.wysiwyg.client.WysiwygEditorTabSwitchHandler;
import org.xwiki.gwt.wysiwyg.client.plugin.PluginFactoryManager;
import org.xwiki.gwt.wysiwyg.client.syntax.SyntaxValidator;
import org.xwiki.gwt.wysiwyg.client.syntax.SyntaxValidatorManager;

public class WysiwygEditor
extends RichTextEditorController {
    private final Widget ui;
    private final WysiwygEditorConfig config;
    private final WysiwygEditorTabSwitchHandler switcher;
    private boolean richTextAreaLoaded;
    private boolean richTextEditorInitialized;

    public WysiwygEditor(Config config, SyntaxValidatorManager svm, PluginFactoryManager pfm) {
        this(new WysiwygEditorConfig(config), svm, pfm);
    }

    public WysiwygEditor(WysiwygEditorConfig config, SyntaxValidatorManager svm, PluginFactoryManager pfm) {
        super(new RichTextEditor(), config.getConfigurationSource(), pfm, WysiwygEditor.getSyntaxValidator(svm, config));
        this.config = config;
        this.switcher = new WysiwygEditorTabSwitchHandler(this);
        if (config.isTabbed()) {
            this.ui = this.createTabPanel();
            this.initializePlainTextArea();
        } else {
            this.ui = this.getRichTextEditor();
        }
        Element hook = config.getHook();
        this.getRichTextEditor().getTextArea().setHeight(Math.max(hook.getOffsetHeight(), 100) + "px");
        hook.getStyle().setDisplay(Style.Display.NONE);
    }

    private static SyntaxValidator getSyntaxValidator(SyntaxValidatorManager svm, WysiwygEditorConfig config) {
        SyntaxValidator sv = svm.getSyntaxValidator(config.getSyntax());
        if (sv == null) {
            sv = svm.getSyntaxValidator("xhtml/1.0");
        }
        return sv;
    }

    @Override
    public void onLoad(LoadEvent event) {
        if (event.getSource() == this.getRichTextEditor().getTextArea() && !this.richTextAreaLoaded) {
            this.richTextAreaLoaded = true;
            boolean inputConverted = this.config.isInputConverted();
            if (inputConverted && StringUtils.isEmpty((String)this.config.getTemplateURL())) {
                this.getRichTextEditor().getTextArea().setHTML(this.config.getInputValue());
                super.onLoad(event);
            } else {
                this.switcher.convertToHTML(inputConverted ? "" : this.config.getInputValue());
            }
        }
    }

    protected void maybeInitializeRichTextEditor() {
        if (!this.richTextEditorInitialized) {
            this.richTextEditorInitialized = true;
            if (this.config.isInputConverted()) {
                this.getRichTextEditor().getTextArea().setHTML(this.config.getInputValue());
            }
            this.maybeInitialize();
        }
    }

    private void initializePlainTextArea() {
        if (this.config.isInputConverted()) {
            this.switcher.convertFromHTML(this.config.getInputValue());
        } else {
            this.getPlainTextEditor().getTextArea().setText(this.config.getInputValue());
        }
    }

    private TabPanel createTabPanel() {
        PlainTextEditor plainTextEditor = new PlainTextEditor(this.config.getHook());
        TabPanel tabs = new TabPanel();
        tabs.add((Widget)this.getRichTextEditor(), Strings.INSTANCE.wysiwyg());
        tabs.add((Widget)plainTextEditor, Strings.INSTANCE.source());
        tabs.setStyleName("xRichTextEditorTabPanel");
        tabs.setAnimationEnabled(false);
        tabs.selectTab(this.config.getSelectedTabIndex());
        boolean richTextAreaEnabled = this.config.isInputConverted();
        plainTextEditor.getTextArea().setEnabled(!richTextAreaEnabled);
        this.getRichTextEditor().getTextArea().setEnabled(richTextAreaEnabled);
        this.saveRegistration(tabs.addBeforeSelectionHandler((BeforeSelectionHandler)this.switcher));
        this.saveRegistration(tabs.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                WysiwygEditor.this.config.setSelectedTabIndex((Integer)event.getSelectedItem());
            }
        }));
        this.saveRegistration(tabs.addSelectionHandler((SelectionHandler)this.switcher));
        return tabs;
    }

    public Widget getUI() {
        return this.ui;
    }

    public PlainTextEditor getPlainTextEditor() {
        return this.config.isTabbed() ? (PlainTextEditor)((TabPanel)this.ui).getWidget(1) : null;
    }

    public int getSelectedTab() {
        return this.ui instanceof TabPanel ? ((TabPanel)this.ui).getTabBar().getSelectedTab() : 0;
    }

    public void setSelectedTab(int index) {
        if (this.ui instanceof TabPanel) {
            ((TabPanel)this.ui).selectTab(index);
        }
    }

    public WysiwygEditorConfig getConfig() {
        return this.config;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.ui.removeFromParent();
    }
}

