/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.TabPanel;
import java.util.HashMap;
import org.xwiki.gwt.user.client.ActionEvent;
import org.xwiki.gwt.user.client.CancelableAsyncCallback;
import org.xwiki.gwt.user.client.Console;
import org.xwiki.gwt.user.client.HasActionHandlers;
import org.xwiki.gwt.user.client.ui.rta.Reloader;
import org.xwiki.gwt.user.client.ui.rta.SelectionPreserver;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.wysiwyg.client.PlainTextEditor;
import org.xwiki.gwt.wysiwyg.client.WysiwygEditor;
import org.xwiki.gwt.wysiwyg.client.converter.HTMLConverter;
import org.xwiki.gwt.wysiwyg.client.converter.HTMLConverterAsync;

public class WysiwygEditorTabSwitchHandler
implements SelectionHandler<Integer>,
BeforeSelectionHandler<Integer> {
    private static final Command SUBMIT = new Command("submit");
    private final WysiwygEditor editor;
    private final HTMLConverterAsync converter = (HTMLConverterAsync)GWT.create(HTMLConverter.class);
    private final Reloader reloader;
    private final String sourceSyntax;
    private CancelableAsyncCallback<String> sourceCallback;
    private CancelableAsyncCallback<String> wysiwygCallback;
    private String lastConvertedHTML;
    private String lastConvertedSourceText;
    private SelectionPreserver domSelectionPreserver;
    private int[] sourceRange = new int[2];

    WysiwygEditorTabSwitchHandler(WysiwygEditor editor) {
        this.editor = editor;
        String templateURL = editor.getConfig().getTemplateURL();
        this.reloader = templateURL == null ? null : new Reloader(editor.getRichTextEditor().getTextArea(), templateURL);
        this.sourceSyntax = editor.getConfig().getSyntax();
        this.domSelectionPreserver = new SelectionPreserver(editor.getRichTextEditor().getTextArea());
    }

    public void onBeforeSelection(BeforeSelectionEvent<Integer> event) {
        int currentlySelectedTab = ((TabPanel)event.getSource()).getTabBar().getSelectedTab();
        if ((Integer)event.getItem() == currentlySelectedTab) {
            event.cancel();
            return;
        }
        switch (currentlySelectedTab) {
            case 0: {
                if (this.editor.getRichTextEditor().isLoading()) break;
                this.editor.getRichTextEditor().getTextArea().getCommandManager().execute(SUBMIT);
                this.domSelectionPreserver.saveSelection();
                break;
            }
            case 1: {
                if (this.editor.getPlainTextEditor().isLoading()) break;
                this.sourceRange[0] = this.editor.getPlainTextEditor().getTextArea().getCursorPos();
                this.sourceRange[1] = this.editor.getPlainTextEditor().getTextArea().getSelectionLength();
                break;
            }
        }
        String[] actionNames = new String[]{"showingWysiwyg", "showingSource"};
        ActionEvent.fire((HasActionHandlers)this.editor.getRichTextEditor().getTextArea(), (String)actionNames[(Integer)event.getItem()]);
    }

    public void onSelection(SelectionEvent<Integer> event) {
        if ((Integer)event.getSelectedItem() == 0) {
            this.switchToWysiwyg();
        } else {
            this.switchToSource();
        }
    }

    private void switchToSource() {
        if (this.editor.getRichTextEditor().isLoading()) {
            this.restoreSourceSelection();
        } else {
            String currentHTML = this.editor.getRichTextEditor().getTextArea().getCommandManager().getStringValue(SUBMIT);
            if (!currentHTML.equals(this.lastConvertedHTML)) {
                this.convertFromHTML(currentHTML);
            } else if (!this.editor.getPlainTextEditor().isLoading()) {
                this.enableSourceTab();
            }
        }
    }

    public void convertFromHTML(String html) {
        this.lastConvertedHTML = html;
        this.sourceRange[0] = 0;
        this.sourceRange[1] = 0;
        if (this.sourceCallback != null) {
            this.sourceCallback.setCanceled(true);
        } else {
            this.editor.getPlainTextEditor().setLoading(true);
        }
        this.sourceCallback = new CancelableAsyncCallback((AsyncCallback)new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                WysiwygEditorTabSwitchHandler.this.sourceCallback = null;
                WysiwygEditorTabSwitchHandler.this.onSwitchToSourceFailure(caught);
            }

            public void onSuccess(String result) {
                WysiwygEditorTabSwitchHandler.this.sourceCallback = null;
                WysiwygEditorTabSwitchHandler.this.onSwitchToSourceSuccess(result);
            }
        });
        this.converter.fromHTML(html, this.sourceSyntax, (AsyncCallback<String>)this.sourceCallback);
    }

    private void onSwitchToSourceFailure(Throwable caught) {
        Console.getInstance().error((Object)caught.getLocalizedMessage(), new Object[0]);
        this.lastConvertedHTML = null;
        this.editor.setSelectedTab(0);
    }

    private void onSwitchToSourceSuccess(String source) {
        this.lastConvertedSourceText = source;
        this.editor.getPlainTextEditor().getTextArea().setText(source);
        this.editor.getPlainTextEditor().setLoading(false);
        if (this.editor.getSelectedTab() == 1) {
            this.enableSourceTab();
        }
    }

    private void enableSourceTab() {
        this.editor.getRichTextEditor().getTextArea().getCommandManager().execute(Command.ENABLE, false);
        this.editor.getPlainTextEditor().getTextArea().setEnabled(true);
        this.editor.getPlainTextEditor().submit();
        this.editor.getConfig().setInputConverted(false);
        this.restoreSourceSelection();
    }

    private void restoreSourceSelection() {
        this.editor.getPlainTextEditor().getTextArea().setFocus(true);
        this.editor.getPlainTextEditor().getTextArea().setSelectionRange(this.sourceRange[0], this.sourceRange[1]);
        ActionEvent.fire((HasActionHandlers)this.editor.getRichTextEditor().getTextArea(), (String)"showSource");
    }

    private void switchToWysiwyg() {
        if (this.editor.getPlainTextEditor().isLoading()) {
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new com.google.gwt.user.client.Command(){

                public void execute() {
                    WysiwygEditorTabSwitchHandler.this.restoreDOMSelection();
                }
            });
        } else {
            String currentSourceText = this.editor.getPlainTextEditor().getTextArea().getText();
            if (!currentSourceText.equals(this.lastConvertedSourceText)) {
                this.convertToHTML(currentSourceText);
            } else if (!this.editor.getRichTextEditor().isLoading()) {
                Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new com.google.gwt.user.client.Command(){

                    public void execute() {
                        if (WysiwygEditorTabSwitchHandler.this.editor.getSelectedTab() == 0 && !WysiwygEditorTabSwitchHandler.this.editor.getRichTextEditor().isLoading()) {
                            WysiwygEditorTabSwitchHandler.this.enableWysiwygTab();
                        }
                    }
                });
            }
        }
    }

    public void convertToHTML(String source) {
        this.lastConvertedSourceText = source;
        this.domSelectionPreserver.clearSelection();
        this.editor.getRichTextEditor().setLoading(true);
        if (this.reloader != null) {
            this.convertToHTMLWithTemplate(source);
        } else {
            this.convertToHTMLWithoutTemplate(source);
        }
    }

    private void convertToHTMLWithTemplate(String source) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("source", source);
        this.reloader.reload(params, (AsyncCallback)new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                WysiwygEditorTabSwitchHandler.this.onSwitchToWysiwygFailure(caught);
            }

            public void onSuccess(Void result) {
                WysiwygEditorTabSwitchHandler.this.onSwitchToWysiwygSuccess();
            }
        });
    }

    private void convertToHTMLWithoutTemplate(String source) {
        if (this.wysiwygCallback != null) {
            this.wysiwygCallback.setCanceled(true);
        }
        this.wysiwygCallback = new CancelableAsyncCallback((AsyncCallback)new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                WysiwygEditorTabSwitchHandler.this.wysiwygCallback = null;
                WysiwygEditorTabSwitchHandler.this.onSwitchToWysiwygFailure(caught);
            }

            public void onSuccess(String result) {
                WysiwygEditorTabSwitchHandler.this.wysiwygCallback = null;
                WysiwygEditorTabSwitchHandler.this.editor.getRichTextEditor().getTextArea().setHTML(result);
                WysiwygEditorTabSwitchHandler.this.onSwitchToWysiwygSuccess();
            }
        });
        this.converter.toHTML(source, this.sourceSyntax, (AsyncCallback<String>)this.wysiwygCallback);
    }

    private void onSwitchToWysiwygFailure(Throwable caught) {
        Console.getInstance().error((Object)caught.getLocalizedMessage(), new Object[0]);
        this.lastConvertedSourceText = null;
        this.editor.setSelectedTab(1);
    }

    private void onSwitchToWysiwygSuccess() {
        this.editor.getRichTextEditor().getTextArea().getCommandManager().execute(Command.RESET);
        if (this.editor.getSelectedTab() == 0) {
            this.enableWysiwygTab();
        }
        this.editor.getRichTextEditor().setLoading(false);
    }

    private void enableWysiwygTab() {
        PlainTextEditor plainTextEditor = this.editor.getPlainTextEditor();
        if (plainTextEditor != null) {
            plainTextEditor.getTextArea().setEnabled(false);
        }
        this.editor.getRichTextEditor().getTextArea().getCommandManager().execute(Command.ENABLE, true);
        this.editor.maybeInitializeRichTextEditor();
        this.restoreDOMSelection();
        this.editor.getRichTextEditor().getTextArea().getCommandManager().execute(SUBMIT, true);
        this.lastConvertedHTML = this.editor.getRichTextEditor().getTextArea().getCommandManager().getStringValue(SUBMIT);
        this.editor.getConfig().setInputConverted(true);
    }

    private void restoreDOMSelection() {
        if (this.domSelectionPreserver.hasSelection()) {
            this.editor.getRichTextEditor().getTextArea().setFocus(true);
        }
        this.domSelectionPreserver.restoreSelection();
        ActionEvent.fire((HasActionHandlers)this.editor.getRichTextEditor().getTextArea(), (String)"showWysiwyg");
    }
}

