/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link;

import com.google.gwt.core.client.Scheduler;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.InnerHTMLListener;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandListener;
import org.xwiki.gwt.user.client.ui.rta.cmd.Executable;
import org.xwiki.gwt.user.client.ui.wizard.Wizard;
import org.xwiki.gwt.user.client.ui.wizard.WizardListener;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.link.EmptyLinkFilter;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfigFactory;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfigJSONSerializer;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkMenuExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkMetaDataExtractor;
import org.xwiki.gwt.wysiwyg.client.plugin.link.exec.CreateLinkExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.link.exec.UnlinkExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkWizard;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class LinkPlugin
extends AbstractPlugin
implements WizardListener {
    private Wizard linkWizard;
    private LinkMenuExtension menuExtension;
    private LinkMetaDataExtractor metaDataExtractor;
    private EmptyLinkFilter linkFilter;
    private Map<Command, Executable> originalExecutables;
    private LinkConfigFactory linkConfigFactory;
    private final WikiServiceAsync wikiService;
    private final LinkConfigJSONSerializer linkConfigJSONSerializer = new LinkConfigJSONSerializer();

    public LinkPlugin(WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
    }

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        Executable createLinkExec = this.getTextArea().getCommandManager().registerCommand(Command.CREATE_LINK, (Executable)new CreateLinkExecutable(textArea));
        Executable unlinkExec = this.getTextArea().getCommandManager().registerCommand(Command.UNLINK, (Executable)new UnlinkExecutable(textArea));
        if (createLinkExec != null || unlinkExec != null) {
            this.originalExecutables = new HashMap<Command, Executable>();
        }
        if (createLinkExec != null) {
            this.originalExecutables.put(Command.CREATE_LINK, createLinkExec);
        }
        if (unlinkExec != null) {
            this.originalExecutables.put(Command.UNLINK, unlinkExec);
        }
        this.menuExtension = new LinkMenuExtension(this);
        this.getUIExtensionList().add(this.menuExtension);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                LinkPlugin.this.menuExtension.registerAttachHandlers();
            }
        });
        this.metaDataExtractor = new LinkMetaDataExtractor();
        this.metaDataExtractor.onInnerHTMLChange((Element)this.getTextArea().getDocument().getDocumentElement());
        this.getTextArea().getDocument().addInnerHTMLListener((InnerHTMLListener)this.metaDataExtractor);
        this.linkFilter = new EmptyLinkFilter(this.getTextArea());
        this.getTextArea().getCommandManager().addCommandListener((CommandListener)this.linkFilter);
        this.linkConfigFactory = new LinkConfigFactory(textArea);
    }

    public void destroy() {
        if (this.originalExecutables != null) {
            for (Map.Entry<Command, Executable> entry : this.originalExecutables.entrySet()) {
                this.getTextArea().getCommandManager().registerCommand(entry.getKey(), entry.getValue());
            }
        }
        if (this.metaDataExtractor != null) {
            this.getTextArea().getDocument().removeInnerHTMLListener((InnerHTMLListener)this.metaDataExtractor);
            this.metaDataExtractor = null;
        }
        this.getTextArea().getCommandManager().removeCommandListener((CommandListener)this.linkFilter);
        this.menuExtension.clearFeatures();
        super.destroy();
    }

    public void onLinkInsert(LinkConfig.LinkType linkType) {
        LinkConfig linkConfig = this.linkConfigFactory.createLinkConfig();
        linkConfig.setType(linkType);
        this.getLinkWizard().start(LinkWizard.LinkWizardStep.LINK_REFERENCE_PARSER.toString(), (Object)linkConfig);
    }

    public void onLinkEdit() {
        this.getLinkWizard().start(LinkWizard.LinkWizardStep.LINK_REFERENCE_PARSER.toString(), (Object)this.linkConfigFactory.createLinkConfig());
    }

    private Wizard getLinkWizard() {
        if (this.linkWizard == null) {
            this.linkWizard = new LinkWizard(this.getConfig(), this.wikiService);
            this.linkWizard.addWizardListener((WizardListener)this);
        }
        return this.linkWizard;
    }

    public void onUnlink() {
        this.getTextArea().setFocus(true);
        this.getTextArea().getCommandManager().execute(Command.UNLINK);
    }

    public void onFinish(Wizard sender, Object result) {
        this.getTextArea().setFocus(true);
        String linkJSON = this.linkConfigJSONSerializer.serialize((LinkConfig)result);
        this.getTextArea().getCommandManager().execute(Command.CREATE_LINK, linkJSON);
    }

    public void onCancel(Wizard sender) {
        this.getTextArea().setFocus(true);
    }
}

