/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro.exec;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import org.xwiki.gwt.user.client.Console;
import org.xwiki.gwt.user.client.ui.LoadingPanel;
import org.xwiki.gwt.user.client.ui.rta.Reloader;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.SelectionPreserver;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandManager;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.AbstractSelectionExecutable;

public class RefreshExecutable
extends AbstractSelectionExecutable
implements AsyncCallback<Object> {
    private static final Command SUBMIT = new Command("submit");
    private static final Command RESET = new Command("reset");
    private final LoadingPanel waiting = new LoadingPanel();
    private final Reloader reloader;
    private final SelectionPreserver selectionPreserver;

    public RefreshExecutable(RichTextArea rta, String url) {
        super(rta);
        this.reloader = new Reloader(rta, url);
        this.selectionPreserver = new SelectionPreserver(rta);
    }

    public boolean execute(String param) {
        if (this.waiting.isLoading()) {
            return false;
        }
        this.waiting.startLoading((Widget)this.rta);
        this.waiting.setFocus(true);
        CommandManager cmdManager = this.rta.getCommandManager();
        this.refresh(cmdManager.execute(SUBMIT) ? cmdManager.getStringValue(SUBMIT) : this.rta.getHTML());
        return true;
    }

    private void refresh(String html) {
        this.reloader.reload(Collections.singletonMap("html", html), (AsyncCallback)this);
    }

    public void onFailure(Throwable caught) {
        Console.getInstance().error((Object)caught.getLocalizedMessage(), new Object[0]);
        this.rta.setFocus(true);
        this.waiting.stopLoading();
    }

    public void onSuccess(Object result) {
        this.selectionPreserver.restoreSelection();
        this.rta.getCommandManager().execute(RESET);
        this.rta.getCommandManager().execute(SUBMIT, true);
        this.rta.setFocus(true);
        this.waiting.stopLoading();
    }
}

