/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.wiki;

import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.gwt.wysiwyg.client.wiki.Attachment;
import org.xwiki.gwt.wysiwyg.client.wiki.AttachmentReference;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityConfig;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPage;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPageReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class WikiServiceAsyncCacheProxy
implements WikiServiceAsync {
    private final WikiServiceAsync service;
    private Boolean isMultiWiki;
    private List<String> virtualWikiNamesList;
    private final Map<EntityReference, String> uploadURLCache = new HashMap<EntityReference, String>();

    public WikiServiceAsyncCacheProxy(WikiServiceAsync service) {
        this.service = service;
    }

    @Override
    public void getPageNames(String wikiName, String spaceName, AsyncCallback<List<String>> async) {
        this.service.getPageNames(wikiName, spaceName, async);
    }

    @Override
    public void getRecentlyModifiedPages(String wikiName, int start, int count, AsyncCallback<List<WikiPage>> async) {
        this.service.getRecentlyModifiedPages(wikiName, start, count, async);
    }

    @Override
    public void getMatchingPages(String wikiName, String keyword, int start, int count, AsyncCallback<List<WikiPage>> async) {
        this.service.getMatchingPages(wikiName, keyword, start, count, async);
    }

    @Override
    public void getSpaceNames(String wikiName, AsyncCallback<List<String>> async) {
        this.service.getSpaceNames(wikiName, async);
    }

    @Override
    public void getVirtualWikiNames(final AsyncCallback<List<String>> async) {
        if (this.virtualWikiNamesList == null) {
            this.service.getVirtualWikiNames(new AsyncCallback<List<String>>(){

                public void onFailure(Throwable caught) {
                    async.onFailure(caught);
                }

                public void onSuccess(List<String> result) {
                    WikiServiceAsyncCacheProxy.this.virtualWikiNamesList = result;
                    async.onSuccess((Object)WikiServiceAsyncCacheProxy.this.virtualWikiNamesList);
                }
            });
        } else {
            async.onSuccess(this.virtualWikiNamesList);
        }
    }

    @Override
    public void isMultiWiki(final AsyncCallback<Boolean> async) {
        if (this.isMultiWiki == null) {
            this.service.isMultiWiki(new AsyncCallback<Boolean>(){

                public void onFailure(Throwable caught) {
                    async.onFailure(caught);
                }

                public void onSuccess(Boolean result) {
                    WikiServiceAsyncCacheProxy.this.isMultiWiki = result;
                    async.onSuccess((Object)WikiServiceAsyncCacheProxy.this.isMultiWiki);
                }
            });
        } else {
            async.onSuccess((Object)this.isMultiWiki);
        }
    }

    @Override
    public void getEntityConfig(EntityReference base, ResourceReference target, AsyncCallback<EntityConfig> async) {
        this.service.getEntityConfig(base, target, async);
    }

    @Override
    public void getAttachment(AttachmentReference attachmentReference, AsyncCallback<Attachment> async) {
        this.service.getAttachment(attachmentReference, async);
    }

    @Override
    public void getImageAttachments(WikiPageReference documentReference, AsyncCallback<List<Attachment>> async) {
        this.service.getImageAttachments(documentReference, async);
    }

    @Override
    public void getAttachments(WikiPageReference documentReference, AsyncCallback<List<Attachment>> async) {
        this.service.getAttachments(documentReference, async);
    }

    @Override
    public void getUploadURL(final WikiPageReference documentReference, final AsyncCallback<String> async) {
        if (this.uploadURLCache.containsKey(documentReference.getEntityReference())) {
            async.onSuccess((Object)this.uploadURLCache.get(documentReference.getEntityReference()));
        } else {
            this.service.getUploadURL(documentReference, new AsyncCallback<String>(){

                public void onFailure(Throwable caught) {
                    async.onFailure(caught);
                }

                public void onSuccess(String result) {
                    WikiServiceAsyncCacheProxy.this.uploadURLCache.put(documentReference.getEntityReference().clone(), result);
                    async.onSuccess((Object)result);
                }
            });
        }
    }

    @Override
    public void parseLinkReference(String linkReference, EntityReference baseReference, AsyncCallback<ResourceReference> async) {
        this.service.parseLinkReference(linkReference, baseReference, async);
    }
}

