/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.WizardStep;
import org.xwiki.gwt.user.client.ui.wizard.WizardStepProvider;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.AttachmentExplorerWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.CreateNewPageWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.CurrentPageAttachmentSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.EmailAddressLinkWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkConfigWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkDispatcherWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkWizard;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.PageSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.WebPageLinkWizardStep;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AttachmentSelectorAggregatorWizardStep;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.LinkUploadWizardStep;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.ResourceReferenceSerializerWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class LinkWizardStepProvider
implements WizardStepProvider {
    private final Map<LinkWizard.LinkWizardStep, WizardStep> steps = new HashMap<LinkWizard.LinkWizardStep, WizardStep>();
    private final Config config;
    private final WikiServiceAsync wikiService;

    public LinkWizardStepProvider(Config config, WikiServiceAsync wikiService) {
        this.config = config;
        this.wikiService = wikiService;
    }

    public WizardStep getStep(String name) {
        LinkWizard.LinkWizardStep requestedStep = this.parseStepName(name);
        WizardStep step = this.steps.get((Object)requestedStep);
        if (step == null && (step = this.getStep(requestedStep)) != null) {
            this.steps.put(requestedStep, step);
        }
        return step;
    }

    private LinkWizard.LinkWizardStep parseStepName(String name) {
        try {
            return LinkWizard.LinkWizardStep.valueOf(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private WizardStep getStep(LinkWizard.LinkWizardStep requestedStep) {
        Object step = null;
        switch (requestedStep) {
            case LINK_REFERENCE_PARSER: {
                step = new LinkDispatcherWizardStep(this.wikiService);
                break;
            }
            case WIKI_PAGE: {
                PageSelectorWizardStep pageSelector = new PageSelectorWizardStep(this.wikiService);
                pageSelector.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.NEXT));
                step = pageSelector;
                break;
            }
            case WIKI_PAGE_CREATOR: {
                step = this.createNewPageSelectorStep();
                break;
            }
            case ATTACHMENT: {
                step = this.createAttachmentSelectorStep();
                break;
            }
            case ATTACHMENT_UPLOAD: {
                step = this.createAttachmentUploadStep();
                break;
            }
            case WEB_PAGE: {
                step = this.createWebPageSelectorStep();
                break;
            }
            case EMAIL: {
                step = this.createEmailSelectorStep();
                break;
            }
            case LINK_CONFIG: {
                step = this.createLinkConfigStep();
                break;
            }
            case LINK_REFERENCE_SERIALIZER: {
                step = this.createLinkReferenceSerializerStep();
                break;
            }
        }
        return step;
    }

    private WizardStep createNewPageSelectorStep() {
        CreateNewPageWizardStep newPageSelector = new CreateNewPageWizardStep();
        newPageSelector.setNextStep(LinkWizard.LinkWizardStep.LINK_CONFIG.toString());
        newPageSelector.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.PREVIOUS, NavigationListener.NavigationDirection.NEXT, NavigationListener.NavigationDirection.FINISH));
        newPageSelector.setDirectionName(NavigationListener.NavigationDirection.NEXT, Strings.INSTANCE.linkSettingsLabel());
        newPageSelector.setDirectionName(NavigationListener.NavigationDirection.FINISH, Strings.INSTANCE.linkCreateLinkButton());
        return newPageSelector;
    }

    private WizardStep createAttachmentSelectorStep() {
        boolean selectionLimitedToCurrentPage = "currentpage".equals(this.config.getParameter("linkfiles"));
        AttachmentSelectorAggregatorWizardStep attachmentSelector = new AttachmentSelectorAggregatorWizardStep(selectionLimitedToCurrentPage);
        attachmentSelector.setStepTitle(Strings.INSTANCE.linkSelectAttachmentTitle());
        attachmentSelector.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.NEXT));
        attachmentSelector.setCurrentPageSelector((WizardStep)new CurrentPageAttachmentSelectorWizardStep(this.wikiService));
        if (!selectionLimitedToCurrentPage) {
            attachmentSelector.setAllPagesSelector((WizardStep)new AttachmentExplorerWizardStep());
        }
        return attachmentSelector;
    }

    private WizardStep createAttachmentUploadStep() {
        LinkUploadWizardStep attachmentUploadStep = new LinkUploadWizardStep(this.wikiService);
        attachmentUploadStep.setFileHelpLabel(Strings.INSTANCE.linkAttachmentUploadHelpLabel());
        attachmentUploadStep.setNextStep(LinkWizard.LinkWizardStep.LINK_CONFIG.toString());
        attachmentUploadStep.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.PREVIOUS, NavigationListener.NavigationDirection.NEXT, NavigationListener.NavigationDirection.FINISH));
        attachmentUploadStep.setDirectionName(NavigationListener.NavigationDirection.NEXT, Strings.INSTANCE.linkSettingsLabel());
        attachmentUploadStep.setDirectionName(NavigationListener.NavigationDirection.FINISH, Strings.INSTANCE.linkCreateLinkButton());
        return attachmentUploadStep;
    }

    private WizardStep createWebPageSelectorStep() {
        WebPageLinkWizardStep webPageSelector = new WebPageLinkWizardStep(this.wikiService);
        webPageSelector.setNextStep(LinkWizard.LinkWizardStep.LINK_REFERENCE_SERIALIZER.toString());
        webPageSelector.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.FINISH));
        webPageSelector.setDirectionName(NavigationListener.NavigationDirection.FINISH, Strings.INSTANCE.linkCreateLinkButton());
        return webPageSelector;
    }

    private WizardStep createEmailSelectorStep() {
        EmailAddressLinkWizardStep emailSelector = new EmailAddressLinkWizardStep(this.wikiService);
        emailSelector.setNextStep(LinkWizard.LinkWizardStep.LINK_REFERENCE_SERIALIZER.toString());
        emailSelector.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.FINISH));
        emailSelector.setDirectionName(NavigationListener.NavigationDirection.FINISH, Strings.INSTANCE.linkCreateLinkButton());
        return emailSelector;
    }

    private WizardStep createLinkConfigStep() {
        LinkConfigWizardStep linkConfigStep = new LinkConfigWizardStep(this.wikiService);
        linkConfigStep.setNextStep(LinkWizard.LinkWizardStep.LINK_REFERENCE_SERIALIZER.toString());
        linkConfigStep.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.FINISH, NavigationListener.NavigationDirection.PREVIOUS));
        linkConfigStep.setDirectionName(NavigationListener.NavigationDirection.FINISH, Strings.INSTANCE.linkCreateLinkButton());
        return linkConfigStep;
    }

    private WizardStep createLinkReferenceSerializerStep() {
        ResourceReferenceSerializerWizardStep linkRefSerializer = new ResourceReferenceSerializerWizardStep(this.wikiService);
        linkRefSerializer.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.PREVIOUS, NavigationListener.NavigationDirection.FINISH));
        linkRefSerializer.setStepTitle(Strings.INSTANCE.linkConfigTitle());
        return linkRefSerializer;
    }
}

