/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro;

import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import java.util.ArrayList;
import java.util.List;
import org.xwiki.gwt.dom.client.Event;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroPlugin;

public class MacroController
implements DoubleClickHandler,
KeyDownHandler {
    private final MacroPlugin plugin;

    public MacroController(MacroPlugin plugin) {
        this.plugin = plugin;
    }

    List<HandlerRegistration> addHadlers() {
        ArrayList<HandlerRegistration> registrations = new ArrayList<HandlerRegistration>();
        registrations.add(this.plugin.getTextArea().addDoubleClickHandler((DoubleClickHandler)this));
        registrations.add(this.plugin.getTextArea().addKeyDownHandler((KeyDownHandler)this));
        return registrations;
    }

    public void onDoubleClick(DoubleClickEvent event) {
        if (event.getSource() == this.plugin.getTextArea() && this.isMacroCurrentlySelected()) {
            this.plugin.edit();
        }
    }

    public void onKeyDown(KeyDownEvent event) {
        int keyCode = event.getNativeKeyCode();
        if (event.getSource() != this.plugin.getTextArea() || keyCode != 13 && keyCode != 32 || !this.isMacroCurrentlySelected()) {
            return;
        }
        if (keyCode == 13) {
            this.plugin.edit();
        } else {
            boolean expanded = this.plugin.getTextArea().getCommandManager().isExecuted(MacroPlugin.EXPAND);
            this.plugin.getTextArea().getCommandManager().execute(expanded ? MacroPlugin.COLLAPSE : MacroPlugin.EXPAND);
        }
        ((Event)event.getNativeEvent()).xPreventDefault();
    }

    private boolean isMacroCurrentlySelected() {
        if (this.plugin.getSelector().getMacroCount() == 1) {
            this.plugin.getSelector().update();
            return this.plugin.getSelector().getMacroCount() == 1;
        }
        return false;
    }
}

