/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.text;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.UIObject;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.dom.client.Style;
import org.xwiki.gwt.user.client.ClickCommand;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ShortcutKey;
import org.xwiki.gwt.user.client.ShortcutKeyCommand;
import org.xwiki.gwt.user.client.ShortcutKeyManager;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.Executable;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.ToggleInlineStyleExecutable;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractStatefulPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.FocusWidgetUIExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.text.exec.BoldExecutable;

public class TextPlugin
extends AbstractStatefulPlugin
implements ClickHandler {
    private final Map<ToggleButton, Command> buttons = new HashMap<ToggleButton, Command>();
    private final FocusWidgetUIExtension toolBarExtension = new FocusWidgetUIExtension("toolbar");
    private final ShortcutKeyManager shortcutKeyManager = new ShortcutKeyManager();

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        this.getTextArea().getCommandManager().registerCommand(Command.BOLD, (Executable)new BoldExecutable(textArea));
        this.getTextArea().getCommandManager().registerCommand(Command.ITALIC, (Executable)new ToggleInlineStyleExecutable(textArea, Style.FONT_STYLE, "italic", "em"));
        this.getTextArea().getCommandManager().registerCommand(Command.UNDERLINE, (Executable)new ToggleInlineStyleExecutable(textArea, Style.TEXT_DECORATION, "underline", "ins"));
        this.getTextArea().getCommandManager().registerCommand(Command.STRIKE_THROUGH, (Executable)new ToggleInlineStyleExecutable(textArea, Style.TEXT_DECORATION, "line-through", "del"));
        this.getTextArea().getCommandManager().registerCommand(Command.TELETYPE, (Executable)new ToggleInlineStyleExecutable(textArea, Style.FONT_FAMILY, "monospace", "tt"));
        this.addFeature("bold", Command.BOLD, Images.INSTANCE.bold(), Strings.INSTANCE.bold(), 'B');
        this.addFeature("italic", Command.ITALIC, Images.INSTANCE.italic(), Strings.INSTANCE.italic(), 'I');
        this.addFeature("underline", Command.UNDERLINE, Images.INSTANCE.underline(), Strings.INSTANCE.underline(), 'U');
        this.addFeature("strikethrough", Command.STRIKE_THROUGH, Images.INSTANCE.strikeThrough(), Strings.INSTANCE.strikeThrough());
        this.addFeature("teletype", Command.TELETYPE, Images.INSTANCE.teletype(), Strings.INSTANCE.teletype());
        if (this.toolBarExtension.getFeatures().length > 0) {
            this.registerTextAreaHandlers();
            this.saveRegistrations(this.shortcutKeyManager.addHandlers((HasAllKeyHandlers)this.getTextArea()));
            this.getUIExtensionList().add(this.toolBarExtension);
        }
    }

    private ToggleButton addFeature(String name, Command command, ImageResource imageResource, String title) {
        ToggleButton button = null;
        if (this.getTextArea().getCommandManager().isSupported(command)) {
            button = new ToggleButton(new Image(imageResource));
            this.saveRegistration(button.addClickHandler((ClickHandler)this));
            button.setTitle(title);
            this.toolBarExtension.addFeature(name, (UIObject)button);
            this.buttons.put(button, command);
        }
        return button;
    }

    private ToggleButton addFeature(String name, Command command, ImageResource imageResource, String title, char keyCode) {
        ToggleButton button = this.addFeature(name, command, imageResource, title);
        if (button != null) {
            ShortcutKeyCommand shortcutKeyCommand = new ShortcutKeyCommand((com.google.gwt.user.client.Command)new ClickCommand((HasClickHandlers)button));
            this.shortcutKeyManager.put((Object)new ShortcutKey((int)keyCode, EnumSet.of(ShortcutKey.ModifierKey.CTRL)), (Object)shortcutKeyCommand);
            this.shortcutKeyManager.put((Object)new ShortcutKey((int)keyCode, EnumSet.of(ShortcutKey.ModifierKey.META)), (Object)shortcutKeyCommand);
        }
        return button;
    }

    public void destroy() {
        for (ToggleButton button : this.buttons.keySet()) {
            button.removeFromParent();
        }
        this.buttons.clear();
        if (this.toolBarExtension.getFeatures().length > 0) {
            this.shortcutKeyManager.clear();
            this.toolBarExtension.clearFeatures();
        }
        super.destroy();
    }

    public void onClick(ClickEvent event) {
        Command command = this.buttons.get(event.getSource());
        if (command != null && this.getTextArea().isAttached() && ((FocusWidget)event.getSource()).isEnabled()) {
            this.getTextArea().setFocus(true);
            this.getTextArea().getCommandManager().execute(command);
        }
    }

    public void update() {
        for (Map.Entry<ToggleButton, Command> entry : this.buttons.entrySet()) {
            if (!entry.getKey().isEnabled()) continue;
            entry.getKey().setDown(this.getTextArea().getCommandManager().isExecuted(entry.getValue()));
        }
    }
}

