/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.wiki;

import com.google.gwt.user.client.rpc.IsSerializable;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPageReference;

public class AttachmentReference
implements IsSerializable {
    public static final String FILE_NAME = "fileName";
    private EntityReference entityReference;
    private WikiPageReference wikiPageReference;

    public AttachmentReference() {
        this(new EntityReference());
        this.entityReference.setType(EntityReference.EntityType.ATTACHMENT);
    }

    public AttachmentReference(EntityReference entityReference) {
        this.entityReference = entityReference;
        this.wikiPageReference = new WikiPageReference(entityReference);
    }

    public AttachmentReference(String fileName, WikiPageReference wikiPageReference) {
        this(wikiPageReference.getEntityReference().clone());
        this.entityReference.setType(EntityReference.EntityType.ATTACHMENT);
        this.setFileName(fileName);
    }

    public String getFileName() {
        return this.entityReference.getComponent(FILE_NAME);
    }

    public void setFileName(String fileName) {
        this.entityReference.setComponent(FILE_NAME, fileName);
    }

    public WikiPageReference getWikiPageReference() {
        return this.wikiPageReference;
    }

    public EntityReference getEntityReference() {
        return this.entityReference;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        String fileName = this.getFileName();
        result = 31 * result + (fileName == null ? 0 : fileName.hashCode());
        result = 31 * result + (this.wikiPageReference == null ? 0 : this.wikiPageReference.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachmentReference)) {
            return false;
        }
        AttachmentReference other = (AttachmentReference)obj;
        return StringUtils.areEqual((String)this.getFileName(), (String)other.getFileName()) && this.wikiPageReference == null ? other.wikiPageReference == null : this.wikiPageReference.equals(other.wikiPageReference);
    }

    public AttachmentReference clone() {
        return new AttachmentReference(this.entityReference.clone());
    }
}

