/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Node;
import org.xwiki.gwt.dom.client.Document;
import org.xwiki.gwt.dom.client.DocumentFragment;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.user.client.EscapeUtils;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.AbstractInsertElementExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;

public final class LinkConfigDOMWriter
implements AbstractInsertElementExecutable.ConfigDOMWriter<LinkConfig, AnchorElement> {
    private static final String TARGET_BLANK = "__blank";

    public void write(LinkConfig config, AnchorElement anchor) {
        this.updateMetaData(anchor, config.getReference(), config.getType());
        anchor.setHref(config.getUrl());
        this.updateAttribute(anchor, "title", config.getTooltip());
        if (config.isOpenInNewWindow()) {
            anchor.setRel(TARGET_BLANK);
        } else if (TARGET_BLANK.equalsIgnoreCase(anchor.getRel())) {
            anchor.removeAttribute("rel");
        }
        if (!anchor.getInnerHTML().equals(config.getLabel())) {
            Element.as((Node)anchor).xSetInnerHTML(config.getLabel());
        }
    }

    private void updateMetaData(AnchorElement anchor, String reference, LinkConfig.LinkType linkType) {
        Document document = (Document)anchor.getOwnerDocument();
        DocumentFragment metaData = document.createDocumentFragment();
        metaData.appendChild(document.createComment("startwikilink:" + EscapeUtils.escapeComment((String)reference)));
        metaData.appendChild((Node)document.createSpanElement());
        Element.as((Node)metaData.getChild(1)).setClassName(linkType.getClassName());
        metaData.getChild(1).appendChild((Node)document.createTextNode("org.xwiki.gwt.dom.client.Element#placeholder"));
        metaData.appendChild(document.createComment("stopwikilink"));
        Element.as((Node)anchor).setMetaData(metaData);
    }

    private void updateAttribute(AnchorElement anchor, String name, String value) {
        if (StringUtils.isEmpty((String)value)) {
            anchor.removeAttribute(name);
        } else {
            anchor.setAttribute(name, value);
        }
    }
}

