/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.user.client.ui.Image;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.wizard.Wizard;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkWizardStepProvider;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPageReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class LinkWizard
extends Wizard {
    private static final Map<LinkConfig.LinkType, ResourceReference.ResourceType> LINK_TYPE_TO_RESOURCE_TYPE_MAP = new HashMap<LinkConfig.LinkType, ResourceReference.ResourceType>();
    private final Config config;

    public LinkWizard(Config config, WikiServiceAsync wikiService) {
        super(Strings.INSTANCE.link(), new Image(Images.INSTANCE.link()));
        this.config = config;
        this.setProvider(new LinkWizardStepProvider(config, wikiService));
    }

    public void start(String startStep, Object data) {
        WikiPageReference origin = new WikiPageReference();
        origin.setWikiName(this.config.getParameter("wiki"));
        origin.setSpaceName(this.config.getParameter("space"));
        origin.setPageName(this.config.getParameter("page"));
        LinkConfig linkConfig = (LinkConfig)data;
        ResourceReference destination = new ResourceReference();
        destination.setType(LINK_TYPE_TO_RESOURCE_TYPE_MAP.get((Object)linkConfig.getType()));
        super.start(startStep, new EntityLink<LinkConfig>(origin.getEntityReference(), destination, linkConfig));
    }

    protected Object getResult() {
        return ((EntityLink)super.getResult()).getData();
    }

    static {
        LINK_TYPE_TO_RESOURCE_TYPE_MAP.put(LinkConfig.LinkType.WIKIPAGE, ResourceReference.ResourceType.DOCUMENT);
        LINK_TYPE_TO_RESOURCE_TYPE_MAP.put(LinkConfig.LinkType.NEW_WIKIPAGE, ResourceReference.ResourceType.DOCUMENT);
        LINK_TYPE_TO_RESOURCE_TYPE_MAP.put(LinkConfig.LinkType.ATTACHMENT, ResourceReference.ResourceType.ATTACHMENT);
        LINK_TYPE_TO_RESOURCE_TYPE_MAP.put(LinkConfig.LinkType.EXTERNAL, ResourceReference.ResourceType.URL);
        LINK_TYPE_TO_RESOURCE_TYPE_MAP.put(LinkConfig.LinkType.EMAIL, ResourceReference.ResourceType.MAILTO);
    }

    public static enum LinkWizardStep {
        LINK_REFERENCE_PARSER,
        WIKI_PAGE,
        WIKI_PAGE_CREATOR,
        ATTACHMENT,
        ATTACHMENT_UPLOAD,
        WEB_PAGE,
        EMAIL,
        LINK_CONFIG,
        LINK_REFERENCE_SERIALIZER;

    }
}

