/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.format;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.UIObject;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.Executable;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.format.exec.FormatBlockExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.format.exec.RemoveFormatExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractStatefulPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.FocusWidgetUIExtension;

public class FormatPlugin
extends AbstractStatefulPlugin
implements ChangeHandler,
ClickHandler {
    private ListBox levels;
    private final Map<PushButton, Command> buttons = new HashMap<PushButton, Command>();
    private final FocusWidgetUIExtension toolBarExtension = new FocusWidgetUIExtension("toolbar");

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        this.getTextArea().getCommandManager().registerCommand(Command.FORMAT_BLOCK, (Executable)new FormatBlockExecutable(textArea));
        this.getTextArea().getCommandManager().registerCommand(Command.REMOVE_FORMAT, (Executable)new RemoveFormatExecutable(textArea));
        this.addFeature("removeformat", Command.REMOVE_FORMAT, Images.INSTANCE.removeFormat(), Strings.INSTANCE.removeFormat());
        if (this.getTextArea().getCommandManager().isSupported(Command.FORMAT_BLOCK)) {
            this.levels = new ListBox(false);
            this.saveRegistration(this.levels.addChangeHandler((ChangeHandler)this));
            this.levels.setVisibleItemCount(1);
            this.levels.setTitle(Strings.INSTANCE.format());
            this.levels.addItem(Strings.INSTANCE.formatPlainText(), "p");
            this.levels.addItem(Strings.INSTANCE.formatHeader1(), "h1");
            this.levels.addItem(Strings.INSTANCE.formatHeader2(), "h2");
            this.levels.addItem(Strings.INSTANCE.formatHeader3(), "h3");
            this.levels.addItem(Strings.INSTANCE.formatHeader4(), "h4");
            this.levels.addItem(Strings.INSTANCE.formatHeader5(), "h5");
            this.levels.addItem(Strings.INSTANCE.formatHeader6(), "h6");
            this.toolBarExtension.addFeature("format", (UIObject)this.levels);
        }
        if (this.toolBarExtension.getFeatures().length > 0) {
            this.registerTextAreaHandlers();
            this.getUIExtensionList().add(this.toolBarExtension);
        }
    }

    private void addFeature(String name, Command command, ImageResource imageResource, String title) {
        if (this.getTextArea().getCommandManager().isSupported(command)) {
            PushButton button = new PushButton(new Image(imageResource));
            this.saveRegistration(button.addClickHandler((ClickHandler)this));
            button.setTitle(title);
            this.toolBarExtension.addFeature(name, (UIObject)button);
            this.buttons.put(button, command);
        }
    }

    public void destroy() {
        for (PushButton button : this.buttons.keySet()) {
            button.removeFromParent();
        }
        this.buttons.clear();
        if (this.levels != null) {
            this.levels.removeFromParent();
            this.levels = null;
            this.toolBarExtension.clearFeatures();
        }
        super.destroy();
    }

    public void onClick(ClickEvent event) {
        Command command = this.buttons.get(event.getSource());
        if (command != null && ((FocusWidget)event.getSource()).isEnabled()) {
            this.getTextArea().setFocus(true);
            this.getTextArea().getCommandManager().execute(command);
        }
    }

    public void onChange(ChangeEvent event) {
        if (event.getSource() == this.levels && this.levels.isEnabled()) {
            String level = this.levels.getValue(this.levels.getSelectedIndex());
            this.getTextArea().setFocus(true);
            this.getTextArea().getCommandManager().execute(Command.FORMAT_BLOCK, level);
        }
    }

    public void update() {
        if (this.levels != null && this.levels.isEnabled()) {
            String level = this.getTextArea().getCommandManager().getStringValue(Command.FORMAT_BLOCK);
            if (level != null) {
                for (int i = 0; i < this.levels.getItemCount(); ++i) {
                    if (!this.levels.getValue(i).equalsIgnoreCase(level)) continue;
                    this.levels.setSelectedIndex(i);
                    return;
                }
                this.levels.setSelectedIndex(0);
            } else {
                this.levels.setSelectedIndex(-1);
            }
        }
    }
}

