/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal.wiki;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.context.Execution;
import org.xwiki.csrf.CSRFToken;
import org.xwiki.gwt.wysiwyg.client.wiki.Attachment;
import org.xwiki.gwt.wysiwyg.client.wiki.AttachmentReference;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityConfig;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPage;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPageReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiService;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.wysiwyg.server.wiki.EntityReferenceConverter;
import org.xwiki.wysiwyg.server.wiki.LinkService;

public class DefaultWikiService
implements WikiService {
    private static final Log LOG = LogFactory.getLog(DefaultWikiService.class);
    @Requirement
    private DocumentAccessBridge documentAccessBridge;
    @Requirement
    private Execution execution;
    @Requirement
    private LinkService linkService;
    @Requirement
    private CSRFToken csrf;
    @Requirement
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Requirement
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    private final EntityReferenceConverter entityReferenceConverter = new EntityReferenceConverter();

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    public Boolean isMultiWiki() {
        return this.getXWikiContext().getWiki().isVirtualMode();
    }

    public List<String> getVirtualWikiNames() {
        List<String> virtualWikiNamesList = new ArrayList();
        try {
            virtualWikiNamesList = this.getXWikiContext().getWiki().getVirtualWikisDatabaseNames(this.getXWikiContext());
            if (virtualWikiNamesList.size() == 0) {
                virtualWikiNamesList.add(this.getXWikiContext().getDatabase());
            }
            Collections.sort(virtualWikiNamesList);
        }
        catch (XWikiException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return virtualWikiNamesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSpaceNames(String wikiName) {
        ArrayList<String> spaceNamesList = new ArrayList();
        String database = this.getXWikiContext().getDatabase();
        try {
            if (wikiName != null) {
                this.getXWikiContext().setDatabase(wikiName);
            }
            spaceNamesList = this.getXWikiContext().getWiki().getSpaces(this.getXWikiContext());
            spaceNamesList.removeAll(this.getBlackListedSpaces());
            Collections.sort(spaceNamesList);
        }
        catch (XWikiException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (wikiName != null) {
                this.getXWikiContext().setDatabase(database);
            }
        }
        return spaceNamesList;
    }

    private List<String> getBlackListedSpaces() {
        List<Object> blacklistedSpaces = (ArrayList)this.getXWikiContext().getRequest().getSession().getAttribute("blacklistedSpaces");
        if (blacklistedSpaces == null) {
            blacklistedSpaces = Collections.emptyList();
        }
        return blacklistedSpaces;
    }

    public List<String> getPageNames(String wikiName, String spaceName) {
        String query = "where doc.space = ? order by doc.fullName asc";
        List<String> parameters = Arrays.asList(spaceName);
        ArrayList<String> pagesNames = new ArrayList<String>();
        for (DocumentReference documentReference : this.searchDocumentReferences(wikiName, query, parameters, 0, 0)) {
            pagesNames.add(documentReference.getName());
        }
        return pagesNames;
    }

    public List<WikiPage> getRecentlyModifiedPages(String wikiName, int start, int count) {
        String query = "where doc.author = ? order by doc.date desc";
        List<String> parameters = Arrays.asList(this.getCurrentUserRelativeTo(wikiName));
        return this.getWikiPages(this.searchDocumentReferences(wikiName, query, parameters, start, count));
    }

    public List<WikiPage> getMatchingPages(String wikiName, String keyword, int start, int count) {
        List<String> blackListedSpaces = this.getBlackListedSpaces();
        String notInBlackListedSpaces = "";
        if (blackListedSpaces.size() > 0) {
            notInBlackListedSpaces = "doc.web not in (?" + StringUtils.repeat((String)",?", (int)(blackListedSpaces.size() - 1)) + ") and ";
        }
        String query = "where " + notInBlackListedSpaces + "(lower(doc.title) like '%'||?||'%' or" + " lower(doc.fullName) like '%'||?||'%')" + " order by doc.fullName asc";
        ArrayList<String> parameters = new ArrayList<String>(blackListedSpaces);
        parameters.add(keyword.toLowerCase());
        parameters.add(keyword.toLowerCase());
        return this.getWikiPages(this.searchDocumentReferences(wikiName, query, parameters, start, count));
    }

    private List<DocumentReference> searchDocumentReferences(String wikiName, String query, List<String> parameters, int start, int count) {
        XWikiContext context = this.getXWikiContext();
        String database = context.getDatabase();
        try {
            if (wikiName != null) {
                context.setDatabase(wikiName);
            }
            List list = context.getWiki().getStore().searchDocumentReferences(query, count, start, parameters, context);
            return list;
        }
        catch (XWikiException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException("Failed to search XWiki pages.", e);
        }
        finally {
            if (wikiName != null) {
                context.setDatabase(database);
            }
        }
    }

    private String getCurrentUserRelativeTo(String wikiName) {
        XWikiContext context = this.getXWikiContext();
        String currentUser = context.getUser();
        String currentWiki = context.getDatabase();
        if (!currentWiki.equals(wikiName)) {
            WikiReference currentWikiRef = new WikiReference(currentWiki);
            DocumentReference currentUserRef = this.documentReferenceResolver.resolve((Object)currentUser, new Object[]{currentWikiRef});
            currentUser = (String)this.entityReferenceSerializer.serialize((org.xwiki.model.reference.EntityReference)currentUserRef, new Object[]{new WikiReference(wikiName)});
        }
        return currentUser;
    }

    private List<WikiPage> getWikiPages(List<DocumentReference> documentReferences) {
        XWikiContext context = this.getXWikiContext();
        ArrayList<WikiPage> wikiPages = new ArrayList<WikiPage>();
        for (DocumentReference documentReference : documentReferences) {
            try {
                WikiPage wikiPage = new WikiPage();
                XWikiDocument document = context.getWiki().getDocument(documentReference, context);
                wikiPage.setReference(this.entityReferenceConverter.convert(documentReference).getEntityReference());
                wikiPage.setTitle(document.getRenderedTitle(Syntax.XHTML_1_0, context));
                wikiPage.setUrl(document.getURL("view", context));
                wikiPages.add(wikiPage);
            }
            catch (XWikiException e) {
                LOG.warn((Object)("Failed to load document " + documentReference), (Throwable)e);
            }
        }
        return wikiPages;
    }

    public EntityConfig getEntityConfig(EntityReference origin, ResourceReference destination) {
        return this.linkService.getEntityConfig(origin, destination);
    }

    public Attachment getAttachment(AttachmentReference attachmentReference) {
        XWikiDocument doc;
        XWikiContext context = this.getXWikiContext();
        String cleanedFileName = context.getWiki().clearName(attachmentReference.getFileName(), false, true, context);
        DocumentReference documentReference = this.entityReferenceConverter.convert(attachmentReference.getWikiPageReference());
        try {
            doc = context.getWiki().getDocument(documentReference, context);
        }
        catch (XWikiException e) {
            LOG.error((Object)"Failed to get attachment: there was a problem with getting the document on the server.", (Throwable)e);
            return null;
        }
        if (doc.isNew()) {
            LOG.warn((Object)String.format("Failed to get attachment: %s document doesn't exist.", documentReference));
            return null;
        }
        if (doc.getAttachment(cleanedFileName) == null) {
            LOG.warn((Object)String.format("Failed to get attachment: %s not found.", cleanedFileName));
            return null;
        }
        AttachmentReference foundAttachmentReference = attachmentReference.clone();
        foundAttachmentReference.setFileName(cleanedFileName);
        Attachment attach = new Attachment();
        attach.setReference(foundAttachmentReference.getEntityReference());
        attach.setUrl(doc.getAttachmentURL(cleanedFileName, context));
        return attach;
    }

    public List<Attachment> getImageAttachments(WikiPageReference reference) {
        ArrayList<Attachment> imageAttachments = new ArrayList<Attachment>();
        List<Attachment> allAttachments = this.getAttachments(reference);
        for (Attachment attachment : allAttachments) {
            if (!attachment.getMimeType().startsWith("image/")) continue;
            imageAttachments.add(attachment);
        }
        return imageAttachments;
    }

    public List<Attachment> getAttachments(WikiPageReference reference) {
        try {
            XWikiContext context = this.getXWikiContext();
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            DocumentReference documentReference = this.entityReferenceConverter.convert(reference);
            XWikiDocument doc = context.getWiki().getDocument(documentReference, context);
            for (XWikiAttachment attach : doc.getAttachmentList()) {
                AttachmentReference attachmentReference = new AttachmentReference(attach.getFilename(), reference);
                Attachment currentAttach = new Attachment();
                currentAttach.setUrl(doc.getAttachmentURL(attach.getFilename(), context));
                currentAttach.setReference(attachmentReference.getEntityReference());
                currentAttach.setMimeType(attach.getMimeType(context));
                attachments.add(currentAttach);
            }
            return attachments;
        }
        catch (XWikiException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException("Failed to retrieve the list of attachments.", e);
        }
    }

    public String getUploadURL(WikiPageReference reference) {
        String queryString = "form_token=" + this.csrf.getToken();
        return this.documentAccessBridge.getDocumentURL(this.entityReferenceConverter.convert(reference), "upload", queryString, null);
    }

    public ResourceReference parseLinkReference(String linkReference, EntityReference baseReference) {
        return this.linkService.parseLinkReference(linkReference, baseReference);
    }
}

