/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.wiki;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xwiki.gwt.wysiwyg.client.wiki.AttachmentReference;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPageReference;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;

public class EntityReferenceConverter {
    private static final Map<EntityType, String> REFERENCE_COMPONENT_NAME = new HashMap<EntityType, String>();

    public org.xwiki.model.reference.EntityReference convert(EntityReference clientEntityReference) {
        String fileName;
        String pageName;
        String spaceName;
        if (clientEntityReference == null) {
            return null;
        }
        org.xwiki.model.reference.EntityReference serverEntityReference = null;
        String wikiName = clientEntityReference.getComponent(REFERENCE_COMPONENT_NAME.get(EntityType.WIKI));
        if (!StringUtils.isEmpty((String)wikiName)) {
            serverEntityReference = new org.xwiki.model.reference.EntityReference(wikiName, EntityType.WIKI);
        }
        if (!StringUtils.isEmpty((String)(spaceName = clientEntityReference.getComponent(REFERENCE_COMPONENT_NAME.get(EntityType.SPACE))))) {
            serverEntityReference = new org.xwiki.model.reference.EntityReference(spaceName, EntityType.SPACE, serverEntityReference);
        }
        if (!StringUtils.isEmpty((String)(pageName = clientEntityReference.getComponent(REFERENCE_COMPONENT_NAME.get(EntityType.DOCUMENT))))) {
            serverEntityReference = new org.xwiki.model.reference.EntityReference(pageName, EntityType.DOCUMENT, serverEntityReference);
        }
        if (!StringUtils.isEmpty((String)(fileName = clientEntityReference.getComponent(REFERENCE_COMPONENT_NAME.get(EntityType.ATTACHMENT))))) {
            serverEntityReference = new org.xwiki.model.reference.EntityReference(fileName, EntityType.ATTACHMENT, serverEntityReference);
        }
        return serverEntityReference;
    }

    public EntityReference convert(org.xwiki.model.reference.EntityReference serverEntityReference) {
        EntityReference clientEntityReference = new EntityReference();
        try {
            clientEntityReference.setType(EntityReference.EntityType.valueOf((String)serverEntityReference.getType().toString()));
        }
        catch (Exception e) {
            return null;
        }
        for (org.xwiki.model.reference.EntityReference child = serverEntityReference; child != null; child = child.getParent()) {
            String componentName = REFERENCE_COMPONENT_NAME.get(child.getType());
            if (componentName == null) continue;
            clientEntityReference.setComponent(componentName, child.getName());
        }
        return clientEntityReference;
    }

    public WikiPageReference convert(DocumentReference documentReference) {
        String wikiName = documentReference.getWikiReference().getName();
        String spaceName = documentReference.getLastSpaceReference().getName();
        String pageName = documentReference.getName();
        return new WikiPageReference(wikiName, spaceName, pageName);
    }

    public DocumentReference convert(WikiPageReference reference) {
        return new DocumentReference(reference.getWikiName(), reference.getSpaceName(), reference.getPageName());
    }

    public AttachmentReference convert(org.xwiki.model.reference.AttachmentReference attachmentReference) {
        return new AttachmentReference(attachmentReference.getName(), this.convert(attachmentReference.getDocumentReference()));
    }

    public org.xwiki.model.reference.AttachmentReference convert(AttachmentReference clientAttachmentReference) {
        return new org.xwiki.model.reference.AttachmentReference(clientAttachmentReference.getFileName(), this.convert(clientAttachmentReference.getWikiPageReference()));
    }

    static {
        REFERENCE_COMPONENT_NAME.put(EntityType.WIKI, "wikiName");
        REFERENCE_COMPONENT_NAME.put(EntityType.SPACE, "spaceName");
        REFERENCE_COMPONENT_NAME.put(EntityType.DOCUMENT, "pageName");
        REFERENCE_COMPONENT_NAME.put(EntityType.ATTACHMENT, "fileName");
    }
}

