/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal.wiki;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityConfig;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceReference;
import org.xwiki.gwt.wysiwyg.client.wiki.URIReference;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.renderer.reference.ResourceReferenceSerializer;
import org.xwiki.wysiwyg.server.wiki.EntityReferenceConverter;
import org.xwiki.wysiwyg.server.wiki.LinkService;

@Component
@Singleton
public class DefaultLinkService
implements LinkService {
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    @Named(value="explicit")
    private EntityReferenceResolver<org.xwiki.model.reference.EntityReference> explicitReferenceEntityReferenceResolver;
    @Inject
    @Named(value="explicit")
    private EntityReferenceResolver<String> explicitStringEntityReferenceResolver;
    @Inject
    @Named(value="xhtmlmarker")
    private ResourceReferenceSerializer linkReferenceSerializer;
    @Inject
    @Named(value="xhtmlmarker")
    private ResourceReferenceParser linkReferenceParser;
    private final EntityReferenceConverter entityReferenceConverter = new EntityReferenceConverter();

    @Override
    public EntityConfig getEntityConfig(EntityReference origin, org.xwiki.gwt.wysiwyg.client.wiki.ResourceReference destination) {
        String destRelativeStrRef;
        String url;
        if (EntityReference.EntityType.EXTERNAL == destination.getEntityReference().getType()) {
            destRelativeStrRef = url = new URIReference(destination.getEntityReference()).getURI();
        } else {
            org.xwiki.model.reference.EntityReference originRef = this.entityReferenceConverter.convert(origin);
            org.xwiki.model.reference.EntityReference destRef = this.entityReferenceConverter.convert(destination.getEntityReference());
            destRef = this.explicitReferenceEntityReferenceResolver.resolve((Object)destRef, destRef.getType(), new Object[]{originRef});
            destRelativeStrRef = (String)this.entityReferenceSerializer.serialize(destRef, new Object[]{originRef});
            url = this.getEntityURL(destRef);
        }
        EntityConfig entityConfig = new EntityConfig();
        entityConfig.setUrl(url);
        entityConfig.setReference(this.getLinkReference(destination.getType(), destination.isTyped(), destRelativeStrRef));
        return entityConfig;
    }

    private String getEntityURL(org.xwiki.model.reference.EntityReference entityReference) {
        switch (entityReference.getType()) {
            case DOCUMENT: {
                DocumentReference documentReference = new DocumentReference(entityReference);
                return this.documentAccessBridge.getDocumentURL(documentReference, "view", null, null);
            }
            case ATTACHMENT: {
                AttachmentReference attachmentReference = new AttachmentReference(entityReference);
                return this.documentAccessBridge.getAttachmentURL(attachmentReference, false);
            }
        }
        return null;
    }

    private String getLinkReference(ResourceReference.ResourceType clientResourceType, boolean typed, String relativeStringEntityReference) {
        ResourceType resourceType = new ResourceType(clientResourceType.getScheme());
        ResourceReference linkReference = new ResourceReference(relativeStringEntityReference, resourceType);
        linkReference.setTyped(typed);
        return this.linkReferenceSerializer.serialize(linkReference);
    }

    @Override
    public org.xwiki.gwt.wysiwyg.client.wiki.ResourceReference parseLinkReference(String linkReferenceAsString, EntityReference baseReference) {
        ResourceReference linkReference = this.linkReferenceParser.parse(linkReferenceAsString);
        org.xwiki.gwt.wysiwyg.client.wiki.ResourceReference clientLinkReference = new org.xwiki.gwt.wysiwyg.client.wiki.ResourceReference();
        clientLinkReference.setType(ResourceReference.ResourceType.forScheme((String)linkReference.getType().getScheme()));
        clientLinkReference.setTyped(linkReference.isTyped());
        clientLinkReference.getParameters().putAll(linkReference.getParameters());
        clientLinkReference.setEntityReference(this.parseEntityReferenceFromResourceReference(linkReference.getReference(), clientLinkReference.getType(), baseReference));
        return clientLinkReference;
    }

    private EntityReference parseEntityReferenceFromResourceReference(String stringEntityReference, ResourceReference.ResourceType resourceType, EntityReference baseReference) {
        EntityReference.EntityType entityType;
        switch (resourceType) {
            case DOCUMENT: {
                entityType = EntityReference.EntityType.DOCUMENT;
                break;
            }
            case ATTACHMENT: {
                entityType = EntityReference.EntityType.ATTACHMENT;
                break;
            }
            default: {
                entityType = EntityReference.EntityType.EXTERNAL;
            }
        }
        if (entityType == EntityReference.EntityType.EXTERNAL) {
            return new URIReference(stringEntityReference).getEntityReference();
        }
        return this.entityReferenceConverter.convert(this.explicitStringEntityReferenceResolver.resolve((Object)stringEntityReference, EntityType.valueOf((String)entityType.toString()), new Object[]{this.entityReferenceConverter.convert(baseReference)}));
    }
}

