/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.server.internal.cleaner;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.component.annotation.Component;
import org.xwiki.wysiwyg.server.internal.cleaner.AbstractHTMLFilter;
import org.xwiki.wysiwyg.server.internal.cleaner.HTMLFilter;

@Component(roles={HTMLFilter.class})
@Named(value="nestedAnchors")
@Singleton
public class NestedAnchorsFilter
extends AbstractHTMLFilter {
    @Inject
    private Logger logger;

    public void filter(Document document, Map<String, String> parameters) {
        try {
            NodeList nestedAnchors = XPathAPI.selectNodeList((Node)document, (String)"//a//a");
            for (int i = 0; i < nestedAnchors.getLength(); ++i) {
                Element nestedAnchor = (Element)nestedAnchors.item(i);
                this.unwrap(nestedAnchor);
            }
        }
        catch (TransformerException e) {
            this.logger.error("Exception while filtering nested anchors.", (Throwable)e);
        }
    }

    private void unwrap(Element element) {
        Document ownerDocument = element.getOwnerDocument();
        if (ownerDocument == null) {
            return;
        }
        Element parent = (Element)element.getParentNode();
        if (parent == null) {
            return;
        }
        DocumentFragment children = element.getOwnerDocument().createDocumentFragment();
        while (element.hasChildNodes()) {
            children.appendChild(element.getChildNodes().item(0));
        }
        parent.replaceChild(children, element);
    }
}

