/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.DefaultSymbolScheme;
import org.xwiki.model.internal.reference.LocalStringEntityReferenceSerializer;
import org.xwiki.model.internal.reference.SymbolScheme;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.xar.XarEntry;
import org.xwiki.xar.XarException;
import org.xwiki.xar.internal.XarUtils;

public class XarPackage {
    private static final LocalStringEntityReferenceSerializer TOSTRING_SERIALIZER = new LocalStringEntityReferenceSerializer((SymbolScheme)new DefaultSymbolScheme());
    private String packageExtensionId;
    private boolean packagePreserveVersion = true;
    private String packageName;
    private String packageDescription;
    private String packageLicense;
    private String packageAuthor;
    private String packageVersion;
    private boolean packageBackupPack;
    private final Map<LocalDocumentReference, XarEntry> packageFiles = new LinkedHashMap<LocalDocumentReference, XarEntry>();
    private final Map<LocalDocumentReference, XarEntry> entries = new LinkedHashMap<LocalDocumentReference, XarEntry>();

    public static Collection<XarEntry> getEntries(File file) throws XarException, IOException {
        XarPackage xarPackage = new XarPackage(file);
        return xarPackage.getEntries();
    }

    public XarPackage() {
    }

    public XarPackage(ZipFile zipFile) throws XarException, IOException {
        this.read(zipFile);
    }

    public XarPackage(File file) throws IOException, XarException {
        if (file.isDirectory()) {
            this.read(file);
        } else {
            try (ZipFile zipFile = new ZipFile(file);){
                this.read(zipFile);
            }
        }
    }

    public XarPackage(InputStream xarStream) throws IOException, XarException {
        this.read(xarStream);
    }

    public XarPackage(Collection<XarEntry> entries) {
        for (XarEntry entry : entries) {
            this.entries.put(entry, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream xarStream) throws IOException, XarException {
        try (ZipArchiveInputStream zis = new ZipArchiveInputStream(xarStream, "UTF-8", false);){
            ZipArchiveEntry entry = zis.getNextZipEntry();
            while (entry != null) {
                if (!entry.isDirectory() && zis.canReadEntryData((ArchiveEntry)entry)) {
                    this.readEntry((InputStream)zis, entry.getName());
                }
                entry = zis.getNextZipEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ZipFile zipFile) throws IOException, XarException {
        Enumeration zipEntries = zipFile.getEntries();
        while (zipEntries.hasMoreElements()) {
            ZipArchiveEntry entry = (ZipArchiveEntry)zipEntries.nextElement();
            if (entry.isDirectory()) continue;
            try (InputStream stream = zipFile.getInputStream(entry);){
                this.readEntry(stream, entry.getName());
            }
        }
    }

    public void read(File directory) throws IOException, XarException {
        String directoryName = directory.getPath();
        directoryName = directoryName + File.separator;
        this.read(directory, directoryName);
    }

    private void read(File directory, String rootDirectory) throws IOException, XarException {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.read(file, rootDirectory);
                continue;
            }
            try (FileInputStream stream = new FileInputStream(file);){
                String entryName = file.getPath();
                entryName = entryName.substring(rootDirectory.length(), entryName.length());
                this.readEntry(stream, entryName);
            }
        }
    }

    private void readEntry(InputStream stream, String entryName) throws XarException, IOException {
        if (entryName.equals("package.xml")) {
            this.readDescriptor(stream);
        } else {
            LocalDocumentReference reference = XarUtils.getReference(stream);
            int defaultAction = this.getDefaultAction(reference);
            String entryType = this.getEntryType(reference);
            XarEntry xarEntry = new XarEntry(reference, entryName, defaultAction, entryType);
            this.entries.put(xarEntry, xarEntry);
            this.updatePackageFile(xarEntry);
        }
    }

    public String getPackageExtensionId() {
        return this.packageExtensionId;
    }

    public void setPackageExtensionId(String packageExtensionId) {
        this.packageExtensionId = packageExtensionId;
    }

    public boolean isPackagePreserveVersion() {
        return this.packagePreserveVersion;
    }

    @Deprecated
    public void setPreserveVersion(boolean preserveVersion) {
        this.packagePreserveVersion = preserveVersion;
    }

    public void setPackagePreserveVersion(boolean packagePreserveVersion) {
        this.packagePreserveVersion = packagePreserveVersion;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageDescription() {
        return this.packageDescription;
    }

    public void setPackageDescription(String packageDescription) {
        this.packageDescription = packageDescription;
    }

    public String getPackageLicense() {
        return this.packageLicense;
    }

    public void setPackageLicense(String packageLicense) {
        this.packageLicense = packageLicense;
    }

    public String getPackageAuthor() {
        return this.packageAuthor;
    }

    public void setPackageAuthor(String packageAuthor) {
        this.packageAuthor = packageAuthor;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public boolean isPackageBackupPack() {
        return this.packageBackupPack;
    }

    public void setPackageBackupPack(boolean packageBackupPack) {
        this.packageBackupPack = packageBackupPack;
    }

    public Collection<XarEntry> getPackageFiles() {
        return this.packageFiles.values();
    }

    public void addPackageFile(LocalDocumentReference reference, int action) {
        this.packageFiles.put(reference, new XarEntry(reference, null, action));
    }

    @Deprecated
    public void addEntry(LocalDocumentReference reference) {
        this.addEntry(reference, null);
    }

    public void addEntry(LocalDocumentReference reference, String entryName) {
        this.addEntry(reference, entryName, 0);
    }

    public void addEntry(LocalDocumentReference reference, String entryName, int action) {
        XarEntry entry = new XarEntry(reference, entryName, action);
        this.entries.put(reference, entry);
        this.packageFiles.put(reference, entry);
    }

    public Collection<XarEntry> getEntries() {
        return this.entries.values();
    }

    public XarEntry getEntry(LocalDocumentReference reference) {
        return this.entries.get(reference);
    }

    public void readDescriptor(InputStream stream) throws XarException, IOException {
        Document doc;
        DocumentBuilder dBuilder;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XarException("Failed to create a new Document builder", e);
        }
        try {
            doc = dBuilder.parse((InputStream)new CloseShieldInputStream(stream));
        }
        catch (SAXException e) {
            throw new XarException("Failed to parse XML document", e);
        }
        doc.getDocumentElement().normalize();
        NodeList children = doc.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element element;
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !(element = (Element)node).getTagName().equals("package")) continue;
            this.readDescriptorPackage(element);
            break;
        }
    }

    private void readDescriptorPackage(Element packageElement) {
        NodeList children = packageElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            if (element.getTagName().equals("infos")) {
                this.readDescriptorInfos(element);
                continue;
            }
            if (!element.getTagName().equals("files")) continue;
            this.readDescriptorFiles(element);
        }
    }

    private void readDescriptorInfos(Element infos) {
        this.packageExtensionId = this.getElementText(infos, "extensionId", true);
        this.packageVersion = this.getElementText(infos, "version", false);
        this.packageName = this.getElementText(infos, "name", false);
        this.packageDescription = this.getElementText(infos, "description", false);
        this.packageLicense = this.getElementText(infos, "licence", false);
        this.packageAuthor = this.getElementText(infos, "author", false);
        this.packageBackupPack = Boolean.parseBoolean(this.getElementText(infos, "backupPack", false));
        this.packagePreserveVersion = Boolean.parseBoolean(this.getElementText(infos, "preserveVersion", false));
    }

    private void readDescriptorFiles(Element files) {
        NodeList children = files.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element element;
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !(element = (Element)node).getTagName().equals("file")) continue;
            String localeString = element.getAttribute("language");
            String defaultActionString = this.getAttribute(element, "defaultAction");
            String entryType = this.getAttribute(element, "type");
            String referenceString = element.getTextContent();
            LocalDocumentReference reference = new LocalDocumentReference(XarUtils.RESOLVER.resolve(referenceString, EntityType.DOCUMENT, new Object[0]), LocaleUtils.toLocale((String)localeString));
            int defaultAction = defaultActionString != null ? Integer.parseInt(defaultActionString) : 0;
            String entryName = this.getEntryName(reference);
            XarEntry packageFile = new XarEntry(reference, entryName, defaultAction, entryType);
            this.packageFiles.put(packageFile, packageFile);
            this.updateEntry(packageFile);
        }
    }

    private String getAttribute(Element element, String attributeName) {
        Attr attrribute = element.getAttributeNode(attributeName);
        return attrribute != null ? attrribute.getValue() : null;
    }

    private String getEntryName(LocalDocumentReference reference) {
        String entryName = null;
        XarEntry entry = this.entries.get(reference);
        if (entry != null) {
            entryName = entry.getEntryName();
        }
        return entryName;
    }

    private int getDefaultAction(LocalDocumentReference reference) {
        int defaultAction = 1;
        XarEntry packageFile = this.packageFiles.get(reference);
        if (packageFile != null) {
            defaultAction = packageFile.getDefaultAction();
        }
        return defaultAction;
    }

    private String getEntryType(LocalDocumentReference reference) {
        String entryType = null;
        XarEntry packageFile = this.packageFiles.get(reference);
        if (packageFile != null) {
            entryType = packageFile.getEntryType();
        }
        return entryType;
    }

    private void updateEntry(XarEntry packageFile) {
        if (this.entries.containsKey((Object)packageFile)) {
            this.entries.put(packageFile, packageFile);
        }
    }

    private void updatePackageFile(XarEntry xarEntry) {
        if (this.packageFiles.containsKey((Object)xarEntry)) {
            this.packageFiles.put(xarEntry, xarEntry);
        }
    }

    private String getElementText(Element element, String tagName, boolean ignoreEmpty) {
        String value;
        NodeList nList = element.getElementsByTagName(tagName);
        String string = value = nList.getLength() > 0 ? nList.item(0).getTextContent() : null;
        if (value != null && ignoreEmpty && StringUtils.isEmpty((CharSequence)value)) {
            value = null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ZipArchiveOutputStream zipStream, String encoding) throws XarException, IOException {
        ZipArchiveEntry zipentry = new ZipArchiveEntry("package.xml");
        zipStream.putArchiveEntry((ArchiveEntry)zipentry);
        try {
            this.write((OutputStream)zipStream, encoding);
        }
        finally {
            zipStream.closeArchiveEntry();
        }
    }

    public void write(OutputStream stream, String encoding) throws XarException {
        XMLStreamWriter writer;
        try {
            writer = XMLOutputFactory.newInstance().createXMLStreamWriter(stream, encoding);
        }
        catch (Exception e) {
            throw new XarException("Failed to create an instance of XML stream writer", e);
        }
        writer = new IndentingXMLStreamWriter(writer);
        try {
            writer.writeStartDocument(encoding, "1.0");
            this.write(writer);
            writer.writeEndDocument();
            writer.flush();
        }
        catch (Exception e) {
            throw new XarException("Failed to write XML", e);
        }
        finally {
            try {
                writer.close();
            }
            catch (XMLStreamException e) {
                throw new XarException("Failed to close XML writer", e);
            }
        }
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("package");
        writer.writeStartElement("infos");
        this.writeElement(writer, "name", this.getPackageName(), true);
        this.writeElement(writer, "description", this.getPackageDescription(), true);
        this.writeElement(writer, "licence", this.getPackageLicense(), true);
        this.writeElement(writer, "author", this.getPackageAuthor(), true);
        this.writeElement(writer, "version", this.getPackageVersion(), true);
        this.writeElement(writer, "backupPack", String.valueOf(this.isPackageBackupPack()), true);
        this.writeElement(writer, "preserveVersion", String.valueOf(this.isPackagePreserveVersion()), true);
        this.writeElement(writer, "extensionId", this.getPackageExtensionId(), false);
        writer.writeEndElement();
        writer.writeStartElement("files");
        for (XarEntry entry : this.entries.values()) {
            writer.writeStartElement("file");
            writer.writeAttribute("defaultAction", String.valueOf(entry.getDefaultAction()));
            writer.writeAttribute("language", Objects.toString(entry.getLocale(), ""));
            if (entry.getEntryType() != null) {
                writer.writeAttribute("type", entry.getEntryType());
            }
            writer.writeCharacters(TOSTRING_SERIALIZER.serialize((EntityReference)entry, new Object[0]));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeElement(XMLStreamWriter streamWriter, String localName, String value, boolean emptyIfNull) throws XMLStreamException {
        if (value != null) {
            if (value.isEmpty()) {
                streamWriter.writeEmptyElement(localName);
            } else {
                streamWriter.writeStartElement(localName);
                streamWriter.writeCharacters(value);
                streamWriter.writeEndElement();
            }
        } else if (emptyIfNull) {
            streamWriter.writeEmptyElement(localName);
        }
    }
}

