/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xar.internal;

import java.io.InputStream;
import java.util.Locale;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.LocaleUtils;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.xar.XarException;
import org.xwiki.xml.stax.StAXUtils;

public final class XarUtils {
    private XarUtils() {
    }

    public static LocalDocumentReference getReference(InputStream documentStream) throws XarException {
        XMLStreamReader xmlReader;
        try {
            xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(documentStream);
        }
        catch (XMLStreamException e) {
            throw new XarException("Failed to create a XML read", e);
        }
        String space = null;
        String page = null;
        Locale locale = null;
        try {
            xmlReader.nextTag();
            xmlReader.require(1, null, "xwikidoc");
            xmlReader.nextTag();
            while (xmlReader.isStartElement()) {
                String elementName = xmlReader.getLocalName();
                if ("name".equals(elementName)) {
                    page = xmlReader.getElementText();
                    if (space != null && locale != null) {
                        break;
                    }
                } else if ("web".equals(elementName)) {
                    space = xmlReader.getElementText();
                    if (page != null && locale != null) {
                        break;
                    }
                } else if ("language".equals(elementName)) {
                    String value = xmlReader.getElementText();
                    locale = value.length() == 0 ? Locale.ROOT : LocaleUtils.toLocale((String)value);
                    if (space != null && page != null) {
                        break;
                    }
                } else {
                    StAXUtils.skipElement((XMLStreamReader)xmlReader);
                }
                xmlReader.nextTag();
            }
        }
        catch (XMLStreamException e) {
            throw new XarException("Failed to parse document", e);
        }
        finally {
            try {
                xmlReader.close();
            }
            catch (XMLStreamException e) {
                throw new XarException("Failed to close XML reader", e);
            }
        }
        if (space == null) {
            throw new XarException("Missing space element");
        }
        if (page == null) {
            throw new XarException("Missing page element");
        }
        if (locale == null) {
            throw new XarException("Missing locale element");
        }
        return new LocalDocumentReference(space, page, locale);
    }
}

