/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.xwiki.component.annotation.Component;
import org.xwiki.script.service.ScriptService;
import org.xwiki.xml.XMLUtils;

@Component
@Named(value="xml")
@Singleton
public class XMLScriptService
implements ScriptService {
    @Inject
    private Logger logger;
    private DOMImplementationLS lsImpl;

    public XMLScriptService() {
        try {
            this.lsImpl = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS 3.0"));
        }
        catch (Exception ex) {
            this.logger.warn("Cannot initialize the XML Script Service", (Throwable)ex);
        }
    }

    public static String escape(Object content) {
        return XMLUtils.escape((Object)content);
    }

    public static String escapeForAttributeValue(Object content) {
        return XMLUtils.escapeAttributeValue((Object)content);
    }

    public static String escapeForElementContent(Object content) {
        return XMLUtils.escapeElementContent((Object)content);
    }

    public static String unescape(Object content) {
        return XMLUtils.unescape((Object)content);
    }

    public Document createDOMDocument() {
        return XMLUtils.createDOMDocument();
    }

    public Document parse(LSInput source) {
        return XMLUtils.parse((LSInput)source);
    }

    public Document parse(byte[] content) {
        if (content == null) {
            return null;
        }
        LSInput input = this.lsImpl.createLSInput();
        input.setByteStream(new ByteArrayInputStream(content));
        return this.parse(input);
    }

    public Document parse(String content) {
        if (content == null) {
            return null;
        }
        LSInput input = this.lsImpl.createLSInput();
        input.setCharacterStream(new StringReader(content));
        return this.parse(input);
    }

    public Document parse(InputStream stream) {
        if (stream == null) {
            return null;
        }
        LSInput input = this.lsImpl.createLSInput();
        input.setByteStream(stream);
        return this.parse(input);
    }

    public String serialize(Node node) {
        return XMLUtils.serialize((Node)node);
    }

    public String serialize(Node node, boolean withXmlDeclaration) {
        return XMLUtils.serialize((Node)node, (boolean)withXmlDeclaration);
    }

    public String transform(Source xml, Source xslt) {
        return XMLUtils.transform((Source)xml, (Source)xslt);
    }

    public String transform(Document xml, Document xslt) {
        if (xml == null || xslt == null) {
            return null;
        }
        return this.transform(new DOMSource(xml), new DOMSource(xslt));
    }

    public String transform(byte[] xml, byte[] xslt) {
        if (xml == null || xslt == null) {
            return null;
        }
        return this.transform(new StreamSource(new ByteArrayInputStream(xml)), new StreamSource(new ByteArrayInputStream(xslt)));
    }

    public String transform(String xml, String xslt) {
        if (xml == null || xslt == null) {
            return null;
        }
        return this.transform(new StreamSource(new StringReader(xml)), new StreamSource(new StringReader(xslt)));
    }
}

