/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xmlrpc;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.codehaus.swizzle.confluence.Attachment;
import org.codehaus.swizzle.confluence.Comment;
import org.codehaus.swizzle.confluence.Page;
import org.codehaus.swizzle.confluence.PageSummary;
import org.codehaus.swizzle.confluence.SearchResult;
import org.codehaus.swizzle.confluence.ServerInfo;
import org.codehaus.swizzle.confluence.Space;
import org.codehaus.swizzle.confluence.SpaceSummary;
import org.xwiki.xmlrpc.model.XWikiClass;
import org.xwiki.xmlrpc.model.XWikiClassSummary;
import org.xwiki.xmlrpc.model.XWikiExtendedId;
import org.xwiki.xmlrpc.model.XWikiObject;
import org.xwiki.xmlrpc.model.XWikiObjectSummary;
import org.xwiki.xmlrpc.model.XWikiPage;
import org.xwiki.xmlrpc.model.XWikiPageHistorySummary;
import org.xwiki.xmlrpc.model.XWikiPageSummary;

public class XWikiXmlRpcClient {
    private XmlRpcClient xmlRpcClient;
    private String token;
    private String rpcHandler;

    public XWikiXmlRpcClient(String endpoint) throws MalformedURLException {
        this(endpoint, "confluence1");
    }

    public XWikiXmlRpcClient(String endpoint, String rpcHandler) throws MalformedURLException {
        XmlRpcClientConfigImpl clientConfig = new XmlRpcClientConfigImpl();
        clientConfig.setServerURL(new URL(endpoint));
        this.xmlRpcClient = new XmlRpcClient();
        this.xmlRpcClient.setConfig((XmlRpcClientConfig)clientConfig);
        this.rpcHandler = rpcHandler;
        this.token = "";
    }

    public void login(String username, String password) throws XmlRpcException {
        this.token = (String)this.invokeRpc("login", username, password);
    }

    public boolean logout() throws XmlRpcException {
        Boolean value = (Boolean)this.invokeRpc("logout", this.token);
        this.token = "";
        return value;
    }

    public ServerInfo getServerInfo() throws XmlRpcException {
        Object object = this.invokeRpc("getServerInfo", this.token);
        return new ServerInfo((Map)object);
    }

    public List<SpaceSummary> getSpaces() throws XmlRpcException {
        Object[] objects = (Object[])this.invokeRpc("getSpaces", this.token);
        ArrayList<SpaceSummary> result = new ArrayList<SpaceSummary>();
        for (Object object : objects) {
            Map spaceSummaryMap = (Map)object;
            SpaceSummary spaceSummary = new SpaceSummary(spaceSummaryMap);
            result.add(spaceSummary);
        }
        return result;
    }

    public Space getSpace(String spaceName) throws XmlRpcException {
        Object object = this.invokeRpc("getSpace", this.token, spaceName);
        return new Space((Map)object);
    }

    public Space getSpace(SpaceSummary spaceSummary) throws XmlRpcException {
        return this.getSpace(spaceSummary.getKey());
    }

    public Space addSpace(Space space) throws XmlRpcException {
        Object object = this.invokeRpc("addSpace", this.token, space.toMap());
        return new Space((Map)object);
    }

    public Boolean removeSpace(String spaceKey) throws XmlRpcException {
        return (Boolean)this.invokeRpc("removeSpace", this.token, spaceKey);
    }

    public Boolean removeSpace(SpaceSummary spaceSummary) throws XmlRpcException {
        return this.removeSpace(spaceSummary.getKey());
    }

    public List<XWikiPageSummary> getPages(String spaceName) throws XmlRpcException {
        Object[] objects = (Object[])this.invokeRpc("getPages", this.token, spaceName);
        ArrayList<XWikiPageSummary> result = new ArrayList<XWikiPageSummary>();
        for (Object object : objects) {
            Map pageSummaryMap = (Map)object;
            XWikiPageSummary pageSummary = new XWikiPageSummary(pageSummaryMap);
            result.add(pageSummary);
        }
        return result;
    }

    public List<XWikiPageSummary> getPages(SpaceSummary space) throws XmlRpcException {
        return this.getPages(space.getKey());
    }

    public XWikiPage getPage(String pageId) throws XmlRpcException {
        Object object = this.invokeRpc("getPage", this.token, pageId);
        return new XWikiPage((Map)object);
    }

    public Page getPage(XWikiPageSummary pageSummary) throws XmlRpcException {
        return this.getPage(pageSummary.getId());
    }

    public XWikiPage getPage(String pageId, String language) throws XmlRpcException {
        XWikiExtendedId extendedId = new XWikiExtendedId(pageId);
        extendedId.setParameter("language", language);
        Object object = this.invokeRpc("getPage", this.token, extendedId.toString());
        return new XWikiPage((Map)object);
    }

    public Page getPage(XWikiPageSummary pageSummary, String language) throws XmlRpcException {
        return this.getPage(pageSummary.getId(), language);
    }

    public XWikiPage getPage(String pageId, Integer version) throws XmlRpcException {
        XWikiExtendedId extendedId = new XWikiExtendedId(pageId);
        extendedId.setParameter("version", version.toString());
        Object object = this.invokeRpc("getPage", this.token, extendedId.toString());
        return new XWikiPage((Map)object);
    }

    public Page getPage(XWikiPageSummary pageSummary, Integer version) throws XmlRpcException {
        return this.getPage(pageSummary.getId(), version);
    }

    public XWikiPage getPage(String pageId, Integer version, Integer minorVersion) throws XmlRpcException {
        XWikiExtendedId extendedId = new XWikiExtendedId(pageId);
        extendedId.setParameter("version", version.toString());
        extendedId.setParameter("minorVersion", minorVersion.toString());
        Object object = this.invokeRpc("getPage", this.token, extendedId.toString());
        return new XWikiPage((Map)object);
    }

    public XWikiPage getPage(XWikiPageHistorySummary pageHistorySummary) throws XmlRpcException {
        return this.getPage(pageHistorySummary.getId(), pageHistorySummary.getVersion(), pageHistorySummary.getMinorVersion());
    }

    public List<XWikiPageHistorySummary> getPageHistory(String pageId) throws XmlRpcException {
        Object[] objects = (Object[])this.invokeRpc("getPageHistory", this.token, pageId);
        ArrayList<XWikiPageHistorySummary> result = new ArrayList<XWikiPageHistorySummary>();
        for (Object object : objects) {
            Map pageHistorySummaryMap = (Map)object;
            XWikiPageHistorySummary pageHistorySummary = new XWikiPageHistorySummary(pageHistorySummaryMap);
            result.add(pageHistorySummary);
        }
        return result;
    }

    public List<XWikiPageHistorySummary> getPageHistory(XWikiPageSummary pageSummary) throws XmlRpcException {
        return this.getPageHistory(pageSummary.getId());
    }

    public XWikiPage storePage(Page page) throws XmlRpcException {
        Object object = this.invokeRpc("storePage", this.token, page.toMap());
        return new XWikiPage((Map)object);
    }

    public Boolean removePage(String pageId) throws XmlRpcException {
        Object object = this.invokeRpc("removePage", this.token, pageId);
        return (Boolean)object;
    }

    public Boolean removePage(XWikiPageSummary page) throws XmlRpcException {
        return this.removePage(page.getId());
    }

    public String renderContent(String space, String pageId, String content) throws XmlRpcException {
        return (String)this.invokeRpc("renderContent", this.token, space, pageId, content);
    }

    public List<Comment> getComments(String pageId) throws XmlRpcException {
        Object[] objects = (Object[])this.invokeRpc("getComments", this.token, pageId);
        ArrayList<Comment> result = new ArrayList<Comment>();
        for (Object object : objects) {
            Map commentMap = (Map)object;
            Comment comment = new Comment(commentMap);
            result.add(comment);
        }
        return result;
    }

    public List<Comment> getComments(PageSummary pageSummary) throws XmlRpcException {
        return this.getComments(pageSummary.getId());
    }

    public Comment getComment(String commentId) throws XmlRpcException {
        Object object = this.invokeRpc("getComment", this.token, commentId);
        return new Comment((Map)object);
    }

    public Comment addComment(Comment comment) throws XmlRpcException {
        Object object = this.invokeRpc("addComment", this.token, comment.toMap());
        return new Comment((Map)object);
    }

    public Boolean removeComment(String commentId) throws XmlRpcException {
        Object object = this.invokeRpc("removeComment", this.token, commentId);
        return (Boolean)object;
    }

    public List<Attachment> getAttachments(String pageId) throws XmlRpcException {
        Object[] objects = (Object[])this.invokeRpc("getAttachments", this.token, pageId);
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        for (Object object : objects) {
            Map attachmentMap = (Map)object;
            Attachment attachment = new Attachment(attachmentMap);
            result.add(attachment);
        }
        return result;
    }

    public List<Attachment> getAttachments(PageSummary pageSummary) throws XmlRpcException {
        return this.getAttachments(pageSummary.getId());
    }

    public byte[] getAttachmentData(String pageId, String fileName, String versionNumber) throws XmlRpcException {
        return (byte[])this.invokeRpc("getAttachmentData", this.token, pageId, fileName, versionNumber);
    }

    public byte[] getAttachmentData(Attachment attachment) throws XmlRpcException {
        return this.getAttachmentData(attachment.getPageId(), attachment.getFileName(), "");
    }

    public Attachment addAttachment(Integer contentId, Attachment attachment, byte[] attachmentData) throws XmlRpcException {
        Object object = this.invokeRpc("addAttachment", this.token, contentId, attachment.toMap(), attachmentData);
        return new Attachment((Map)object);
    }

    public Boolean removeAttachment(String pageId, String fileName) throws XmlRpcException {
        return (Boolean)this.invokeRpc("removeAttachment", this.token, pageId, fileName);
    }

    public Boolean removeAttachment(Attachment attachment) throws XmlRpcException {
        return this.removeAttachment(attachment.getPageId(), attachment.getFileName());
    }

    public List<XWikiClassSummary> getClasses() throws XmlRpcException {
        Object[] objects = (Object[])this.invokeRpc("getClasses", this.token);
        ArrayList<XWikiClassSummary> result = new ArrayList<XWikiClassSummary>();
        for (Object object : objects) {
            Map xwikiClassSummaryMap = (Map)object;
            XWikiClassSummary xwikiClassSummary = new XWikiClassSummary(xwikiClassSummaryMap);
            result.add(xwikiClassSummary);
        }
        return result;
    }

    public XWikiClass getClass(String className) throws XmlRpcException {
        Object object = this.invokeRpc("getClass", this.token, className);
        return new XWikiClass((Map)object);
    }

    public XWikiClass getClass(XWikiClassSummary classSummary) throws XmlRpcException {
        return this.getClass(classSummary.getId());
    }

    public List<XWikiObjectSummary> getObjects(String pageId) throws XmlRpcException {
        Object[] objects = (Object[])this.invokeRpc("getObjects", this.token, pageId);
        ArrayList<XWikiObjectSummary> result = new ArrayList<XWikiObjectSummary>();
        for (Object object : objects) {
            Map xwikiObjectSummaryMap = (Map)object;
            XWikiObjectSummary xwikiObjectSummary = new XWikiObjectSummary(xwikiObjectSummaryMap);
            result.add(xwikiObjectSummary);
        }
        return result;
    }

    public List<XWikiObjectSummary> getObjects(String pageId, Integer version) throws XmlRpcException {
        XWikiExtendedId extendedId = new XWikiExtendedId(pageId);
        extendedId.setParameter("version", version.toString());
        Object[] objects = (Object[])this.invokeRpc("getObjects", this.token, extendedId.toString());
        ArrayList<XWikiObjectSummary> result = new ArrayList<XWikiObjectSummary>();
        for (Object object : objects) {
            Map xwikiObjectSummaryMap = (Map)object;
            XWikiObjectSummary xwikiObjectSummary = new XWikiObjectSummary(xwikiObjectSummaryMap);
            result.add(xwikiObjectSummary);
        }
        return result;
    }

    public List<XWikiObjectSummary> getObjects(String pageId, Integer version, Integer minorVersion) throws XmlRpcException {
        XWikiExtendedId extendedId = new XWikiExtendedId(pageId);
        extendedId.setParameter("version", version.toString());
        extendedId.setParameter("minorVersion", minorVersion.toString());
        Object[] objects = (Object[])this.invokeRpc("getObjects", this.token, extendedId.toString());
        ArrayList<XWikiObjectSummary> result = new ArrayList<XWikiObjectSummary>();
        for (Object object : objects) {
            Map xwikiObjectSummaryMap = (Map)object;
            XWikiObjectSummary xwikiObjectSummary = new XWikiObjectSummary(xwikiObjectSummaryMap);
            result.add(xwikiObjectSummary);
        }
        return result;
    }

    public List<XWikiObjectSummary> getObjects(PageSummary pageSummary) throws XmlRpcException {
        return this.getObjects(pageSummary.getId());
    }

    public XWikiObject getObject(String pageId, String className, Integer id) throws XmlRpcException {
        Object object = this.invokeRpc("getObject", this.token, pageId, className, id);
        return new XWikiObject((Map)object);
    }

    public XWikiObject getObject(String pageId, String guid) throws XmlRpcException {
        Object object = this.invokeRpc("getObject", this.token, pageId, guid);
        return new XWikiObject((Map)object);
    }

    public XWikiObject getObject(String pageId, String className, Integer id, Integer version) throws XmlRpcException {
        XWikiExtendedId extendedId = new XWikiExtendedId(pageId);
        extendedId.setParameter("version", version.toString());
        Object object = this.invokeRpc("getObject", this.token, extendedId.toString(), className, id);
        return new XWikiObject((Map)object);
    }

    public XWikiObject getObject(String pageId, String className, Integer id, Integer version, Integer minorVersion) throws XmlRpcException {
        XWikiExtendedId extendedId = new XWikiExtendedId(pageId);
        extendedId.setParameter("version", version.toString());
        extendedId.setParameter("minorVersion", minorVersion.toString());
        Object object = this.invokeRpc("getObject", this.token, extendedId.toString(), className, id);
        return new XWikiObject((Map)object);
    }

    public XWikiObject getObject(XWikiObjectSummary xwikiObjectSummary) throws XmlRpcException {
        return this.getObject(xwikiObjectSummary.getPageId(), xwikiObjectSummary.getClassName(), xwikiObjectSummary.getId());
    }

    public XWikiObject storeObject(XWikiObject xwikiObject) throws XmlRpcException {
        Object object = this.invokeRpc("storeObject", this.token, xwikiObject.toRawMap());
        return new XWikiObject((Map)object);
    }

    public Boolean removeObject(String pageId, String className, Integer id) throws XmlRpcException {
        Object object = this.invokeRpc("removeObject", this.token, pageId, className, id);
        return (Boolean)object;
    }

    public Boolean removeObject(XWikiObjectSummary objectSummary) throws XmlRpcException {
        return this.removeObject(objectSummary.getPageId(), objectSummary.getClassName(), objectSummary.getId());
    }

    public List<SearchResult> search(String query, Integer maxResults) throws XmlRpcException {
        Object[] objects = (Object[])this.invokeRpc("search", this.token, query, maxResults);
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        for (Object object : objects) {
            Map searchResultMap = (Map)object;
            SearchResult searchResult = new SearchResult(searchResultMap);
            result.add(searchResult);
        }
        return result;
    }

    public List<SearchResult> searchAllPagesIds() throws XmlRpcException {
        Object[] objects = (Object[])this.invokeRpc("search", this.token, "__ALL_PAGES__", 0);
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        for (Object object : objects) {
            Map searchResultMap = (Map)object;
            SearchResult searchResult = new SearchResult(searchResultMap);
            result.add(searchResult);
        }
        return result;
    }

    public List<XWikiPageHistorySummary> getModifiedPagesHistory(Date date, Integer numberOfResults, Integer start, Boolean fromLatest) throws XmlRpcException {
        Object[] objects = (Object[])this.invokeRpc("getModifiedPagesHistory", this.token, date, numberOfResults, start, fromLatest);
        ArrayList<XWikiPageHistorySummary> result = new ArrayList<XWikiPageHistorySummary>();
        for (Object object : objects) {
            Map pageHistorySummaryMap = (Map)object;
            XWikiPageHistorySummary pageHistorySummary = new XWikiPageHistorySummary(pageHistorySummaryMap);
            result.add(pageHistorySummary);
        }
        return result;
    }

    public List<XWikiPageHistorySummary> getModifiedPagesHistory(Integer numberOfResults, Integer start, Boolean fromLatest) throws XmlRpcException {
        return this.getModifiedPagesHistory(new Date(0L), numberOfResults, start, fromLatest);
    }

    public List<XWikiPageHistorySummary> getModifiedPagesHistory(Integer numberOfResults, Integer start) throws XmlRpcException {
        return this.getModifiedPagesHistory(new Date(0L), numberOfResults, start, true);
    }

    public XWikiPage storePage(Page page, Boolean checkVersion) throws XmlRpcException {
        Object object = this.invokeRpc("storePage", this.token, page.toMap(), checkVersion);
        return new XWikiPage((Map)object);
    }

    public XWikiObject storeObject(XWikiObject xwikiObject, Boolean checkVersion) throws XmlRpcException {
        Object object = this.invokeRpc("storeObject", this.token, xwikiObject.toRawMap(), checkVersion);
        return new XWikiObject((Map)object);
    }

    public String convert(String source, String initialSyntaxId, String targetSyntaxId) throws XmlRpcException {
        return (String)this.invokeRpc("convert", this.token, source, initialSyntaxId, targetSyntaxId);
    }

    public List<String> getInputSyntaxes() throws XmlRpcException {
        Object[] objects;
        ArrayList<String> result = new ArrayList<String>();
        for (Object object : objects = (Object[])this.invokeRpc("getInputSyntaxes", this.token)) {
            result.add((String)object);
        }
        return result;
    }

    public List<String> getOutputSyntaxes() throws XmlRpcException {
        Object[] objects;
        ArrayList<String> result = new ArrayList<String>();
        for (Object object : objects = (Object[])this.invokeRpc("getOutputSyntaxes", this.token)) {
            result.add((String)object);
        }
        return result;
    }

    public String renderPageContent(String pageId, String content, String sourceSyntaxId, String targetSyntaxId) throws XmlRpcException {
        return (String)this.invokeRpc("renderPageContent", this.token, pageId, content, sourceSyntaxId, targetSyntaxId);
    }

    public String getRenderedContent(String pageId, String syntaxId) throws XmlRpcException {
        return (String)this.invokeRpc("getRenderedContent", this.token, pageId, syntaxId);
    }

    private synchronized Object invokeRpc(String methodName, Object ... args) throws XmlRpcException {
        return this.xmlRpcClient.execute(String.format("%s.%s", this.rpcHandler, methodName), args);
    }
}

