/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xmlrpc.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xwiki.xmlrpc.model.XWikiObjectSummary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWikiObject
extends XWikiObjectSummary {
    public static final String PROPERTY_ALLOWED_VALUES_SUFFIX = "##allowed_values";
    public static final String PROPERTY_TYPE_SUFFIX = "##type";

    public XWikiObject() {
        this.setMap("propertyToValueMap", new HashMap());
    }

    public XWikiObject(Map map) {
        super(map);
        if (this.getMap("propertyToValueMap") == null) {
            this.setMap("propertyToValueMap", new HashMap());
        }
    }

    public Object getProperty(String propertyName) {
        Map propertyToValueMap = this.getMap("propertyToValueMap");
        Object value = propertyToValueMap.get(propertyName);
        if (value != null && value.getClass().isArray()) {
            ArrayList<Object> array = new ArrayList<Object>();
            for (Object o : (Object[])value) {
                array.add(o);
            }
            value = array;
            propertyToValueMap.put(propertyName, value);
        }
        return value;
    }

    public void setProperty(String propertyName, Object value) {
        Map propertyToValueMap = this.getMap("propertyToValueMap");
        propertyToValueMap.put(propertyName, value);
    }

    public Set<String> getProperties() {
        HashSet<String> result = new HashSet<String>();
        Map propertyToValueMap = this.getMap("propertyToValueMap");
        for (String property : propertyToValueMap.keySet()) {
            if (property.endsWith(PROPERTY_ALLOWED_VALUES_SUFFIX) || property.endsWith(PROPERTY_TYPE_SUFFIX)) continue;
            result.add(property);
        }
        return result;
    }

    public void setPropertyAllowedValues(String propertyName, List values) {
        this.setProperty(String.format("%s%s", propertyName, PROPERTY_ALLOWED_VALUES_SUFFIX), values);
    }

    public List getPropertyAllowedValues(String propertyName) {
        return (List)this.getProperty(String.format("%s%s", propertyName, PROPERTY_ALLOWED_VALUES_SUFFIX));
    }

    public void setPropertyType(String propertyName, String type) {
        this.setProperty(String.format("%s%s", propertyName, PROPERTY_TYPE_SUFFIX), type);
    }

    public String getPropertyType(String propertyName) {
        return (String)this.getProperty(String.format("%s%s", propertyName, PROPERTY_TYPE_SUFFIX));
    }
}

