/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.gwt.user.client.ui.wizard;


import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * An abstract wizard step that is a widget composite.
 * 
 * @version $Id: AbstractCompositeWizardStep.java 24888 2009-11-06 02:16:19Z sdumitriu $
 */
public abstract class AbstractCompositeWizardStep extends Composite implements WizardStep
{
    /**
     * Creates a new composite wizard step.
     */
    public AbstractCompositeWizardStep()
    {
        this(new FlowPanel());
    }

    /**
     * Creates a new composite wizard step that uses the given panel to hold its widgets.
     * 
     * @param panel the panel where this wizard step will add its widgets
     */
    public AbstractCompositeWizardStep(FlowPanel panel)
    {
        initWidget(panel);
    }

    /**
     * {@inheritDoc}
     * 
     * @see WizardStep#display()
     */
    public Widget display()
    {
        return this;
    }

    /**
     * @return the panel that holds all the widgets of this wizard step
     */
    protected FlowPanel getPanel()
    {
        return (FlowPanel) getWidget();
    }
}
