/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image;

import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.Node;
import org.xwiki.gwt.dom.client.DocumentFragment;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.Style;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfig;

public class ImageConfigHTMLParser {
    public ImageConfig parse(ImageElement image) {
        ImageConfig config = new ImageConfig();
        config.setReference(this.parseReference(image));
        config.setImageURL(image.getSrc());
        String width = image.getAttribute("width");
        if (StringUtils.isEmpty((String)width) && StringUtils.isEmpty((String)(width = image.getStyle().getWidth()))) {
            width = String.valueOf(image.getWidth());
        }
        config.setWidth(width);
        String height = image.getAttribute("height");
        if (StringUtils.isEmpty((String)height) && StringUtils.isEmpty((String)(height = image.getStyle().getHeight()))) {
            height = String.valueOf(image.getHeight());
        }
        config.setHeight(height);
        config.setAltText(image.getAlt());
        config.setAlignment(this.parseImageAlignment(image));
        return config;
    }

    private String parseReference(ImageElement image) {
        DocumentFragment metaData = Element.as((Node)image).getMetaData();
        if (metaData == null) {
            return null;
        }
        Node startComment = metaData.getFirstChild();
        if (startComment == null || startComment.getNodeType() != 8 || !startComment.getNodeValue().startsWith("startimage:")) {
            return null;
        }
        return startComment.getNodeValue().substring(11);
    }

    private ImageConfig.ImageAlignment parseImageAlignment(ImageElement image) {
        try {
            return ImageConfig.ImageAlignment.valueOf(image.getStyle().getVerticalAlign().toUpperCase());
        }
        catch (Exception e) {
            try {
                return ImageConfig.ImageAlignment.valueOf(image.getStyle().getProperty(Style.FLOAT.getJSName()).toUpperCase());
            }
            catch (Exception f) {
                String display = image.getStyle().getDisplay();
                String marginLeft = image.getStyle().getMarginLeft();
                String marginRight = image.getStyle().getMarginRight();
                if ("block".equalsIgnoreCase(display) && "auto".equalsIgnoreCase(marginLeft) && "auto".equalsIgnoreCase(marginRight)) {
                    return ImageConfig.ImageAlignment.CENTER;
                }
                return null;
            }
        }
    }
}

