/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image;

import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfig;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceName;

public final class ImageConfigHTMLSerializer {
    private static final String PIXELS_OR_PERCENT = "^\\+?[1-9]\\d*(\\.\\d+)?(px|%)?$";
    private static final Map<ImageConfig.ImageAlignment, String> ALIGNMENT = new HashMap<ImageConfig.ImageAlignment, String>();

    public String serialize(ImageConfig imageConfig) {
        String height;
        String width;
        StringBuffer imageHTML = new StringBuffer();
        imageHTML.append("<!--startimage:");
        imageHTML.append(imageConfig.getReference());
        imageHTML.append("--><img src=\"");
        imageHTML.append(imageConfig.getImageURL());
        imageHTML.append("\" alt=\"");
        String altText = imageConfig.getAltText();
        if (StringUtils.isEmpty((String)altText)) {
            altText = new ResourceName(imageConfig.getReference(), true).getFile();
        }
        imageHTML.append(altText + "\" ");
        StringBuffer style = new StringBuffer();
        String alignment = ALIGNMENT.get((Object)imageConfig.getAlignment());
        if (alignment != null) {
            style.append(alignment);
        }
        if (!StringUtils.isEmpty((String)(width = imageConfig.getWidth()))) {
            if (width.matches(PIXELS_OR_PERCENT)) {
                imageHTML.append("width=\"" + width + "\" ");
            } else {
                style.append("width:" + width + ';');
            }
        }
        if (!StringUtils.isEmpty((String)(height = imageConfig.getHeight()))) {
            if (height.matches(PIXELS_OR_PERCENT)) {
                imageHTML.append("height=\"" + height + "\" ");
            } else {
                style.append("height:" + height + ';');
            }
        }
        imageHTML.append(style.length() > 0 ? "style=\"" + style + "\" " : "");
        imageHTML.append("/><!--stopimage-->");
        return imageHTML.toString();
    }

    static {
        ALIGNMENT.put(ImageConfig.ImageAlignment.LEFT, "float: left; margin-right: 1em;");
        ALIGNMENT.put(ImageConfig.ImageAlignment.RIGHT, "float: right; margin-left: 1em;");
        ALIGNMENT.put(ImageConfig.ImageAlignment.CENTER, "margin-right: auto; margin-left: auto; display: block;");
        ALIGNMENT.put(ImageConfig.ImageAlignment.TOP, "vertical-align: top;");
        ALIGNMENT.put(ImageConfig.ImageAlignment.MIDDLE, "vertical-align: middle;");
        ALIGNMENT.put(ImageConfig.ImageAlignment.BOTTOM, "vertical-align: bottom;");
    }
}

