/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image.ui;

import com.google.gwt.user.client.ui.Image;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.wizard.Wizard;
import org.xwiki.gwt.user.client.ui.wizard.WizardStep;
import org.xwiki.gwt.user.client.ui.wizard.WizardStepProvider;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.CurrentPageImageSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.ImageConfigWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.ImageSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.ImageUploadWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceName;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class ImageWizard
extends Wizard
implements WizardStepProvider {
    private Map<ImageWizardSteps, WizardStep> stepsMap = new HashMap<ImageWizardSteps, WizardStep>();
    private final Config config;
    private final WikiServiceAsync wikiService;

    public ImageWizard(Config config, WikiServiceAsync wikiService) {
        super(Strings.INSTANCE.imageTooltip(), new Image(Images.INSTANCE.image()));
        this.config = config;
        this.wikiService = wikiService;
        this.setProvider(this);
    }

    public WizardStep getStep(String name) {
        ImageWizardSteps requestedStep = this.parseStepName(name);
        WizardStep step = this.stepsMap.get((Object)requestedStep);
        if (step == null) {
            switch (requestedStep) {
                case IMAGE_SELECTOR: {
                    step = this.dispatchImageSelectorStep();
                    break;
                }
                case IMAGE_CONFIG: {
                    step = new ImageConfigWizardStep();
                    break;
                }
                case IMAGE_UPLOAD: {
                    step = new ImageUploadWizardStep(this.getEditedResource());
                    ((ImageUploadWizardStep)step).setWikiService(this.wikiService);
                    break;
                }
            }
            if (step != null) {
                this.stepsMap.put(requestedStep, step);
            }
        }
        return step;
    }

    private ResourceName getEditedResource() {
        return new ResourceName(this.config.getParameter("wiki"), this.config.getParameter("space"), this.config.getParameter("page"), null);
    }

    private WizardStep dispatchImageSelectorStep() {
        String insertImages = this.config.getParameter("insertimages");
        if ("currentpage".equals(insertImages)) {
            CurrentPageImageSelectorWizardStep step = new CurrentPageImageSelectorWizardStep(this.getEditedResource());
            step.setWikiService(this.wikiService);
            return step;
        }
        ImageSelectorWizardStep step = new ImageSelectorWizardStep(this.getEditedResource());
        step.setWikiService(this.wikiService);
        return step;
    }

    private ImageWizardSteps parseStepName(String name) {
        ImageWizardSteps requestedStep = null;
        try {
            requestedStep = ImageWizardSteps.valueOf(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return requestedStep;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageWizardSteps {
        IMAGE_SELECTOR,
        IMAGE_CONFIG,
        IMAGE_UPLOAD;

    }
}

