/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.importer.ui;

import com.google.gwt.user.client.ui.Image;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.wizard.Wizard;
import org.xwiki.gwt.user.client.ui.wizard.WizardStep;
import org.xwiki.gwt.user.client.ui.wizard.WizardStepProvider;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.importer.ImportServiceAsync;
import org.xwiki.gwt.wysiwyg.client.plugin.importer.ui.ImportOfficeFileWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.importer.ui.ImportOfficePasteWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class ImportWizard
extends Wizard
implements WizardStepProvider {
    private Map<ImportWizardStep, WizardStep> stepsMap = new HashMap<ImportWizardStep, WizardStep>();
    private final Config config;
    private final ImportServiceAsync importService;
    private final WikiServiceAsync wikiService;

    public ImportWizard(Config config, ImportServiceAsync importService, WikiServiceAsync wikiService) {
        super(Strings.INSTANCE.importWizardTitle(), new Image(Images.INSTANCE.importWizardIcon()));
        this.config = config;
        this.importService = importService;
        this.wikiService = wikiService;
        this.setProvider(this);
    }

    public WizardStep getStep(String name) {
        ImportWizardStep requestedStep = this.parseStepName(name);
        WizardStep step = this.stepsMap.get((Object)requestedStep);
        if (null == step) {
            switch (requestedStep) {
                case OFFICE_FILE: {
                    step = new ImportOfficeFileWizardStep(this.config, this.importService);
                    ((ImportOfficeFileWizardStep)step).setWikiService(this.wikiService);
                    break;
                }
                case OFFICE_PASTE: {
                    step = new ImportOfficePasteWizardStep(this.importService);
                    break;
                }
            }
            if (step != null) {
                this.stepsMap.put(requestedStep, step);
            }
        }
        return step;
    }

    private ImportWizardStep parseStepName(String name) {
        ImportWizardStep requestedStep = null;
        try {
            requestedStep = ImportWizardStep.valueOf(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return requestedStep;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImportWizardStep {
        OFFICE_FILE,
        OFFICE_PASTE;

    }
}

