/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link;

import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xwiki.gwt.dom.client.JavaScriptObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkConfig
implements IsSerializable {
    private static final String TOOLTIP_ATTRIBUTE = "title";
    private static final String TARGET_ATTRIBUTE = "rel";
    private static final String NEW_WINDOW_TARGET_VALUE = "__blank";
    private static final String PARAM_PREFIX = "_x";
    private String url;
    private String wiki;
    private String space;
    private String page;
    private String reference;
    private String labelText;
    private boolean readOnlyLabel;
    private String label;
    private LinkType type;
    private Map<String, String> parameters = new HashMap<String, String>();

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getWiki() {
        return this.wiki;
    }

    public void setWiki(String wiki) {
        this.wiki = wiki;
    }

    public String getSpace() {
        return this.space;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public LinkType getType() {
        return this.type;
    }

    public void setType(LinkType type) {
        this.type = type;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    public boolean isReadOnlyLabel() {
        return this.readOnlyLabel;
    }

    public void setReadOnlyLabel(boolean readOnlyLabel) {
        this.readOnlyLabel = readOnlyLabel;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public boolean isOpenInNewWindow() {
        String value = this.getParameter(TARGET_ATTRIBUTE);
        return NEW_WINDOW_TARGET_VALUE.equals(value);
    }

    public void setOpenInNewWindow(boolean openInNewWindow) {
        if (openInNewWindow) {
            this.setParameter(TARGET_ATTRIBUTE, NEW_WINDOW_TARGET_VALUE);
        } else {
            this.removeParameter(TARGET_ATTRIBUTE);
        }
    }

    public String getTooltip() {
        return this.getParameter(TOOLTIP_ATTRIBUTE);
    }

    public void setTooltip(String tooltip) {
        this.setParameter(TOOLTIP_ATTRIBUTE, tooltip);
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public String setParameter(String name, String value) {
        return this.parameters.put(name, value);
    }

    public String removeParameter(String name) {
        return this.parameters.remove(name);
    }

    public String toJSON() {
        String jsonString = "{ " + this.formatValue("reference", this.getReference()) + this.formatValue("url", this.getUrl()) + this.formatValue("label", this.getLabel()) + this.formatValue("labeltext", this.getLabelText()) + this.formatValue("readonlylabel", this.isReadOnlyLabel() ? Boolean.valueOf(true) : null) + this.formatValue("type", (Object)this.getType());
        for (Map.Entry<String, String> param : this.parameters.entrySet()) {
            jsonString = jsonString + this.formatValue(PARAM_PREFIX + param.getKey(), param.getValue());
        }
        if (jsonString.length() > 4) {
            jsonString = jsonString.substring(0, jsonString.length() - 2);
        }
        jsonString = jsonString + " }";
        return jsonString;
    }

    private String formatValue(String key, Object value) {
        return value != null ? key + ": '" + value.toString().replace("'", "\\'") + "', " : "";
    }

    public void fromJSON(String json) {
        JavaScriptObject jsObj = JavaScriptObject.fromJson((String)json);
        this.setReference((String)jsObj.get("reference"));
        this.setUrl((String)jsObj.get("url"));
        this.setLabel((String)jsObj.get("label"));
        this.setLabelText((String)jsObj.get("labeltext"));
        this.setReadOnlyLabel(jsObj.get("readonlylabel") != null ? Boolean.parseBoolean((String)jsObj.get("readonlylabel")) : false);
        this.setType(jsObj.get("type") != null ? LinkType.valueOf((String)jsObj.get("type")) : null);
        List<String> processedKeys = Arrays.asList("reference", "url", "label", "labeltext", "readonlylabel", "type");
        JsArrayString keys = jsObj.getKeys();
        for (int i = 0; i < keys.length(); ++i) {
            if (processedKeys.contains(keys.get(i))) continue;
            this.parameters.put(keys.get(i).substring(2), jsObj.get(keys.get(i)).toString());
        }
    }

    public Iterable<Map.Entry<String, String>> listParameters() {
        return new Iterable<Map.Entry<String, String>>(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return LinkConfig.this.parameters.entrySet().iterator();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LinkType {
        EXTERNAL,
        NEW_WIKIPAGE,
        WIKIPAGE,
        ATTACHMENT,
        EMAIL;

    }
}

