/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.smartgwt.client.widgets.events.KeyPressEvent;
import com.smartgwt.client.widgets.events.KeyPressHandler;
import com.smartgwt.client.widgets.grid.events.RecordDoubleClickEvent;
import com.smartgwt.client.widgets.grid.events.RecordDoubleClickHandler;
import org.xwiki.gwt.user.client.ui.VerticalResizePanel;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListenerCollection;
import org.xwiki.gwt.user.client.ui.wizard.SourcesNavigationEvents;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.widget.explorer.XWikiExplorer;
import org.xwiki.gwt.wysiwyg.client.widget.explorer.ds.WikiDataSource;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractSelectorWizardStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExplorerWizardStep
extends AbstractSelectorWizardStep<LinkConfig>
implements SourcesNavigationEvents,
RecordDoubleClickHandler,
KeyPressHandler {
    protected static final String FIELD_ERROR_STYLE = "xErrorField";
    private XWikiExplorer explorer;
    private final VerticalResizePanel mainPanel = new VerticalResizePanel();
    private final Label errorLabel = new Label();
    private NavigationListenerCollection listeners = new NavigationListenerCollection();

    public AbstractExplorerWizardStep(boolean addPage, boolean showAttachments, boolean addAttachments, String defaultSelection) {
        this(addPage, showAttachments, addAttachments, defaultSelection, 455, 305);
    }

    protected AbstractExplorerWizardStep(boolean addPage, boolean showAttachments, boolean addAttachments, String defaultSelection, int width, int height) {
        this.explorer = new XWikiExplorer();
        this.explorer.setDisplayLinks(false);
        this.explorer.setDisplayAddPage(addPage);
        this.explorer.setDisplayAddPageOnTop(true);
        this.explorer.setDisplayAttachments(showAttachments);
        this.explorer.setDisplayAddAttachment(showAttachments && addAttachments);
        this.explorer.setDisplayAddAttachmentOnTop(true);
        this.explorer.setDisplayAttachmentsWhenEmpty(showAttachments && addAttachments);
        String sizeUnit = "px";
        this.explorer.setWidth(width + sizeUnit);
        this.explorer.setHeight(height + sizeUnit);
        WikiDataSource ds = new WikiDataSource();
        this.explorer.setDataSource(ds);
        this.explorer.setDefaultValue(defaultSelection);
        this.explorer.getElement().setClassName(this.explorer.getElement().getClassName() + " xExplorer");
        this.explorer.addRecordDoubleClickHandler(this);
        this.explorer.addKeyPressHandler(this);
        Label helpLabel = new Label();
        helpLabel.addStyleName("xHelpLabel");
        helpLabel.setText(this.getHelpLabelText());
        this.mainPanel.add((Widget)helpLabel);
        this.errorLabel.setText(this.getDefaultErrorText());
        this.errorLabel.setVisible(false);
        this.errorLabel.addStyleName("xErrorMsg");
        this.mainPanel.add((Widget)this.errorLabel);
        this.mainPanel.addStyleName("xExplorerPanel");
        this.mainPanel.add((Widget)this.explorer);
        this.mainPanel.setExpandingWidget((Widget)this.explorer, true);
    }

    protected abstract String getHelpLabelText();

    protected abstract String getDefaultErrorText();

    protected void invalidateExplorerData() {
        try {
            this.explorer.invalidateCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Widget display() {
        return this.mainPanel;
    }

    public XWikiExplorer getExplorer() {
        return this.explorer;
    }

    public Label getErrorLabel() {
        return this.errorLabel;
    }

    @Override
    public void init(Object data, AsyncCallback<?> cb) {
        this.hideError();
        super.init(data, cb);
    }

    protected void displayError(String errorMessage) {
        this.errorLabel.setText(errorMessage);
        this.errorLabel.setVisible(true);
        if (!this.explorer.getElement().getClassName().contains(FIELD_ERROR_STYLE)) {
            this.explorer.getElement().setClassName(this.explorer.getElement().getClassName() + " " + FIELD_ERROR_STYLE);
        }
        this.mainPanel.refreshHeights();
    }

    protected void hideError() {
        this.errorLabel.setVisible(false);
        String boundary = "\\b";
        this.explorer.getElement().setClassName(this.explorer.getElement().getClassName().replaceAll(boundary + FIELD_ERROR_STYLE + boundary, ""));
        this.mainPanel.refreshHeights();
    }

    public void addNavigationListener(NavigationListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void onRecordDoubleClick(RecordDoubleClickEvent event) {
        this.listeners.fireNavigationEvent(NavigationListener.NavigationDirection.NEXT);
    }

    public void onKeyPress(KeyPressEvent event) {
        if ("Enter".equals(event.getKeyName())) {
            this.listeners.fireNavigationEvent(NavigationListener.NavigationDirection.NEXT);
        }
    }
}

