/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.ListItem;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkWizard;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractListSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceName;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPageListSelectorWizardStep
extends AbstractListSelectorWizardStep<LinkConfig, WikiPage> {
    private ResourceName editedResource;

    public AbstractPageListSelectorWizardStep(ResourceName editedResource) {
        this.getMainPanel().addStyleName("xPagesSelector");
        this.editedResource = editedResource;
    }

    @Override
    protected String getSelectHelpLabel() {
        return Strings.INSTANCE.linkSelectWikipageHelpLabel();
    }

    @Override
    protected String getSelectErrorMessage() {
        return Strings.INSTANCE.linkNoPageSelectedError();
    }

    @Override
    protected String getSelection() {
        if (!StringUtils.isEmpty((String)((LinkConfig)this.getData()).getReference())) {
            return ((LinkConfig)this.getData()).getReference();
        }
        if (this.getSelectedItem() != null && this.getSelectedItem().getData() != null) {
            return ((WikiPage)this.getSelectedItem().getData()).getName();
        }
        return null;
    }

    @Override
    protected boolean matchesSelection(WikiPage item, String selection) {
        return selection != null && selection.equals(item.getName());
    }

    @Override
    protected ListItem<WikiPage> getListItem(WikiPage data) {
        ListItem item = new ListItem();
        item.setData((Object)data);
        Label pageName = new Label(data.getName());
        pageName.addStyleName("xPagePreviewFullname");
        Label title = new Label(data.getTitle());
        title.addStyleName("xPagePreviewTitle");
        FlowPanel ui = new FlowPanel();
        if (!StringUtils.isEmpty((String)data.getTitle())) {
            ui.add((Widget)title);
        }
        String prettyName = StringUtils.isEmpty((String)data.getTitle()) ? "" : data.getTitle() + " - ";
        prettyName = prettyName + data.getName();
        ui.setTitle(prettyName);
        ui.add((Widget)pageName);
        ui.addStyleName("xPagePreview");
        item.add((Widget)ui);
        return item;
    }

    @Override
    protected ListItem<WikiPage> getNewOptionListItem() {
        ListItem item = new ListItem();
        item.setData(null);
        Label newOptionPanel = new Label(Strings.INSTANCE.linkNewPageOptionLabel());
        newOptionPanel.addStyleName("xNewPagePreview");
        item.add((Widget)newOptionPanel);
        return item;
    }

    public String getNextStep() {
        if (this.getSelectedItem() != null && this.getSelectedItem().getData() == null) {
            return LinkWizard.LinkWizardSteps.WIKI_PAGE_CREATOR.toString();
        }
        return LinkWizard.LinkWizardSteps.WIKI_PAGE_CONFIG.toString();
    }

    public String getStepTitle() {
        return Strings.INSTANCE.linkSelectWikipageTitle();
    }

    @Override
    protected void saveSelectedValue() {
        WikiPage selectedDocument = (WikiPage)this.getSelectedItem().getData();
        if (selectedDocument == null) {
            ((LinkConfig)this.getData()).setWiki(this.editedResource.getWiki());
            ((LinkConfig)this.getData()).setSpace(this.editedResource.getSpace());
        } else {
            boolean changedDoc = true;
            ResourceName editedPage = new ResourceName(((LinkConfig)this.getData()).getReference(), false).getRelativeTo(this.editedResource);
            ResourceName selectedPage = new ResourceName(selectedDocument.getName(), false).getRelativeTo(this.editedResource);
            if (!StringUtils.isEmpty((String)((LinkConfig)this.getData()).getReference()) && editedPage.equals(selectedPage)) {
                changedDoc = false;
            }
            if (changedDoc) {
                ResourceName ref = new ResourceName(selectedDocument.getName(), false);
                ((LinkConfig)this.getData()).setReference(ref.getRelativeTo(this.editedResource).toString());
                ((LinkConfig)this.getData()).setUrl(selectedDocument.getURL());
            }
        }
    }
}

