/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.symbol;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.UIObject;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.CompositeDialogBox;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.FocusWidgetUIExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.symbol.SymbolPicker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolPlugin
extends AbstractPlugin
implements ClickHandler,
CloseHandler<CompositeDialogBox> {
    private PushButton insert;
    private SymbolPicker picker;
    private final FocusWidgetUIExtension toolBarExtension = new FocusWidgetUIExtension("toolbar");

    @Override
    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        if (this.getTextArea().getCommandManager().isSupported(Command.INSERT_HTML)) {
            this.insert = new PushButton(new Image(Images.INSTANCE.charmap()));
            this.saveRegistration(this.insert.addClickHandler((ClickHandler)this));
            this.insert.setTitle(Strings.INSTANCE.charmap());
            this.toolBarExtension.addFeature("symbol", (UIObject)this.insert);
        }
        if (this.toolBarExtension.getFeatures().length > 0) {
            this.getUIExtensionList().add(this.toolBarExtension);
        }
    }

    @Override
    public void destroy() {
        if (this.insert != null) {
            this.insert.removeFromParent();
            this.insert = null;
            if (this.picker != null) {
                this.picker.hide();
                this.picker.removeFromParent();
                this.picker = null;
            }
        }
        this.toolBarExtension.clearFeatures();
        super.destroy();
    }

    public void onClick(ClickEvent event) {
        if (event.getSource() == this.insert) {
            this.onSymbols(true);
        }
    }

    public void onClose(CloseEvent<CompositeDialogBox> event) {
        if (event.getSource() == this.getSymbolPicker() && !event.isAutoClosed()) {
            this.onSymbols(false);
        }
    }

    public void onSymbols(boolean show) {
        if (show) {
            if (this.insert.isEnabled()) {
                this.getSymbolPicker().center();
            }
        } else {
            this.getTextArea().setFocus(true);
            String character = this.getSymbolPicker().getSymbol();
            if (character != null && this.getTextArea().getCommandManager().execute(Command.INSERT_HTML, character)) {
                this.getTextArea().getDocument().getSelection().collapseToEnd();
            }
        }
    }

    private SymbolPicker getSymbolPicker() {
        if (this.picker == null) {
            this.picker = new SymbolPicker();
            this.saveRegistration(this.picker.addCloseHandler(this));
        }
        return this.picker;
    }
}

