/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.widget;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ListBox;
import java.util.List;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageSelector
extends ListBox {
    private String wiki;
    private String space;
    private WikiServiceAsync wikiService;

    public PageSelector(String space) {
        this(null, space);
    }

    public PageSelector(String wiki, String space) {
        super(false);
        this.wiki = wiki;
        this.space = space;
    }

    public void refreshList(final String currentPage, final AsyncCallback<List<String>> cb) {
        this.clear();
        this.wikiService.getPageNames(this.wiki, this.space, new AsyncCallback<List<String>>(){

            public void onFailure(Throwable caught) {
                throw new RuntimeException(caught.getMessage());
            }

            public void onSuccess(List<String> result) {
                for (String s : result) {
                    PageSelector.this.addItem(s);
                    if (!s.equals(currentPage)) continue;
                    PageSelector.this.setSelectedIndex(PageSelector.this.getItemCount() - 1);
                }
                if (cb != null) {
                    cb.onSuccess(result);
                }
            }
        });
    }

    public void refreshList(String currentPage) {
        this.refreshList(currentPage, null);
    }

    public String getSelectedPage() {
        if (this.getSelectedIndex() >= 0) {
            return this.getItemText(this.getSelectedIndex());
        }
        return null;
    }

    public void setSelectedPage(String page) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!this.getItemText(i).equals(page)) continue;
            this.setSelectedIndex(i);
        }
    }

    public String getWiki() {
        return this.wiki;
    }

    public void setWiki(String wiki) {
        this.wiki = wiki;
    }

    public String getSpace() {
        return this.space;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public void setWikiService(WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
    }
}

