/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.widget.wizard.util;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.EnumSet;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.WizardStep;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.wiki.Attachment;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileUploadWizardStep
implements WizardStep {
    protected static final String FIELD_ERROR_STYLE = "xErrorField";
    private final Panel mainPanel = new FlowPanel();
    private final FormPanel fileUploadForm = new FormPanel();
    private final FileUpload fileUploadInput = new FileUpload();
    private final Label fileErrorLabel = new Label();
    private WikiServiceAsync wikiService;

    public AbstractFileUploadWizardStep() {
        this.mainPanel.addStyleName("xUploadPanel");
        this.fileUploadForm.setEncoding("multipart/form-data");
        this.fileUploadForm.setMethod("post");
        FlowPanel fileLabel = new FlowPanel();
        fileLabel.setStyleName("xInfoLabel");
        fileLabel.add((Widget)new InlineLabel(this.getFileLabel()));
        InlineLabel mandatoryLabel = new InlineLabel(Strings.INSTANCE.mandatory());
        mandatoryLabel.addStyleName("xMandatory");
        fileLabel.add((Widget)mandatoryLabel);
        this.fileUploadInput.setName(this.getFileUploadInputName());
        this.fileUploadInput.getElement().setAttribute("size", "50");
        FlowPanel formPanel = new FlowPanel();
        formPanel.add((Widget)fileLabel);
        if (!StringUtils.isEmpty((String)this.getFileHelpLabel())) {
            Label fileHelpLabel = new Label(this.getFileHelpLabel());
            fileHelpLabel.setStyleName("xHelpLabel");
            formPanel.add((Widget)fileHelpLabel);
        }
        this.fileErrorLabel.addStyleName("xErrorMsg");
        this.fileErrorLabel.setVisible(false);
        formPanel.add((Widget)this.fileErrorLabel);
        formPanel.add((Widget)this.fileUploadInput);
        this.fileUploadForm.setWidget((Widget)formPanel);
        this.mainPanel.add((Widget)this.fileUploadForm);
    }

    protected String getFileLabel() {
        return Strings.INSTANCE.fileUploadLabel();
    }

    protected abstract String getFileHelpLabel();

    protected String getUploadURL() {
        StringBuffer uploadURL = new StringBuffer();
        uploadURL.append("../../upload/");
        uploadURL.append(URL.encodeComponent((String)this.getSpace()));
        uploadURL.append('/');
        uploadURL.append(URL.encodeComponent((String)this.getPage()));
        return uploadURL.toString();
    }

    protected String getFileUploadInputName() {
        return "filepath";
    }

    public void init(Object data, AsyncCallback<?> cb) {
        this.hideError();
        cb.onSuccess(null);
    }

    public Widget display() {
        return this.mainPanel;
    }

    public String getDirectionName(NavigationListener.NavigationDirection direction) {
        if (direction == NavigationListener.NavigationDirection.NEXT) {
            return Strings.INSTANCE.fileUploadSubmitLabel();
        }
        return null;
    }

    public String getStepTitle() {
        return Strings.INSTANCE.fileUploadTitle();
    }

    public EnumSet<NavigationListener.NavigationDirection> getValidDirections() {
        return EnumSet.of(NavigationListener.NavigationDirection.CANCEL, NavigationListener.NavigationDirection.PREVIOUS, NavigationListener.NavigationDirection.NEXT);
    }

    public void onCancel() {
    }

    public void onSubmit(final AsyncCallback<Boolean> async) {
        HandlerRegistration[] registrations;
        this.fileUploadForm.setAction(this.getUploadURL());
        registrations = new HandlerRegistration[]{this.fileUploadForm.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                AbstractFileUploadWizardStep.this.onSubmitComplete(event, (AsyncCallback<Boolean>)async);
                registrations[0].removeHandler();
            }
        })};
        this.hideError();
        if (this.fileUploadInput.getFilename().trim().length() == 0) {
            this.displayError(Strings.INSTANCE.fileUploadNoPathError());
            async.onSuccess((Object)false);
            return;
        }
        this.fileUploadForm.submit();
    }

    protected void onSubmitComplete(FormPanel.SubmitCompleteEvent event, final AsyncCallback<Boolean> async) {
        this.wikiService.getAttachment(this.getWiki(), this.getSpace(), this.getPage(), this.extractFileName(), new AsyncCallback<Attachment>(){

            public void onSuccess(Attachment result) {
                if (result == null) {
                    AbstractFileUploadWizardStep.this.displayError(Strings.INSTANCE.fileUploadSubmitError());
                    async.onSuccess((Object)false);
                } else {
                    AbstractFileUploadWizardStep.this.onAttachmentUploaded(result, (AsyncCallback<Boolean>)async);
                }
            }

            public void onFailure(Throwable caught) {
                async.onFailure(caught);
            }
        });
    }

    protected abstract void onAttachmentUploaded(Attachment var1, AsyncCallback<Boolean> var2);

    protected abstract String getWiki();

    protected abstract String getSpace();

    protected abstract String getPage();

    protected String extractFileName() {
        String fname = this.getFileUploadInput().getFilename();
        fname = StringUtils.substringAfterLast((String)fname, (String)"/");
        fname = StringUtils.substringAfterLast((String)fname, (String)"\\");
        return fname;
    }

    protected Panel getMainPanel() {
        return this.mainPanel;
    }

    protected FileUpload getFileUploadInput() {
        return this.fileUploadInput;
    }

    protected void displayError(String errorMessage) {
        this.fileErrorLabel.setText(errorMessage);
        this.fileErrorLabel.setVisible(true);
        this.fileUploadInput.addStyleName(FIELD_ERROR_STYLE);
    }

    protected void hideError() {
        this.fileErrorLabel.setVisible(false);
        this.fileUploadInput.removeStyleName(FIELD_ERROR_STYLE);
    }

    public void setWikiService(WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
    }
}

