/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client;

import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.user.client.ActionEvent;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.DeferredUpdater;
import org.xwiki.gwt.user.client.HandlerRegistrationCollection;
import org.xwiki.gwt.user.client.HasActionHandlers;
import org.xwiki.gwt.user.client.Updatable;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandListener;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandManager;
import org.xwiki.gwt.wysiwyg.client.RichTextEditor;
import org.xwiki.gwt.wysiwyg.client.ToolBarController;
import org.xwiki.gwt.wysiwyg.client.plugin.PluginFactoryManager;
import org.xwiki.gwt.wysiwyg.client.plugin.PluginManager;
import org.xwiki.gwt.wysiwyg.client.plugin.UIExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.DefaultPluginManager;
import org.xwiki.gwt.wysiwyg.client.syntax.SyntaxValidator;

public class RichTextEditorController
implements Updatable,
MouseUpHandler,
KeyUpHandler,
CommandListener,
LoadHandler {
    public static final String MENU_ROLE = "menu";
    public static final String DEFAULT_PLUGINS = "submit line separator text valign justify list indent history format font color symbol table";
    private static final String WHITE_SPACE_SEPARATOR = "\\s+";
    private static final Command SUBMIT = new Command("submit");
    private final Config config;
    private final RichTextEditor richTextEditor;
    private final ToolBarController toolBarController;
    private final PluginManager pluginManager;
    private final SyntaxValidator syntaxValidator;
    private final DeferredUpdater updater = new DeferredUpdater((Updatable)this);
    private final HandlerRegistrationCollection registrations = new HandlerRegistrationCollection();
    private boolean loaded;

    public RichTextEditorController(RichTextEditor richTextEditor, Config config, PluginFactoryManager pfm, SyntaxValidator syntaxValidator) {
        this.config = config;
        this.richTextEditor = richTextEditor;
        this.registrations.add((Object)richTextEditor.getTextArea().addLoadHandler((LoadHandler)this));
        this.registrations.add((Object)richTextEditor.getTextArea().addMouseUpHandler((MouseUpHandler)this));
        this.registrations.add((Object)richTextEditor.getTextArea().addKeyUpHandler((KeyUpHandler)this));
        richTextEditor.getTextArea().getCommandManager().addCommandListener((CommandListener)this);
        this.toolBarController = new ToolBarController(richTextEditor.getToolbar());
        this.syntaxValidator = syntaxValidator;
        this.pluginManager = new DefaultPluginManager(richTextEditor.getTextArea(), config);
        this.pluginManager.setPluginFactoryManager(pfm);
    }

    public void onMouseUp(MouseUpEvent event) {
        if (event.getSource() == this.richTextEditor.getTextArea()) {
            this.updater.deferUpdate();
        }
    }

    public void onKeyUp(KeyUpEvent event) {
        if (event.getSource() == this.richTextEditor.getTextArea()) {
            this.updater.deferUpdate();
        }
    }

    public boolean onBeforeCommand(CommandManager sender, Command command, String param) {
        return false;
    }

    public void onCommand(CommandManager sender, Command command, String param) {
        if (sender == this.richTextEditor.getTextArea().getCommandManager()) {
            this.updater.deferUpdate();
        }
    }

    public void onLoad(LoadEvent event) {
        if (event.getSource() == this.richTextEditor.getTextArea() && !this.loaded) {
            this.loaded = true;
            this.loadPlugins();
            this.extendRootUI();
            this.fillMenu();
            this.toolBarController.fill(this.config, this.pluginManager);
            this.initTextArea();
            ActionEvent.fire((HasActionHandlers)this.getRichTextEditor().getTextArea(), (String)"loaded");
        }
    }

    protected void loadPlugins() {
        String[] pluginNames = this.config.getParameter("plugins", DEFAULT_PLUGINS).split(WHITE_SPACE_SEPARATOR);
        for (int i = 0; i < pluginNames.length; ++i) {
            this.pluginManager.load(pluginNames[i]);
        }
    }

    protected void extendRootUI() {
        String[] rootExtensionNames = this.config.getParameter("rootUI", SUBMIT.toString()).split(WHITE_SPACE_SEPARATOR);
        for (int i = 0; i < rootExtensionNames.length; ++i) {
            UIExtension rootExtension = this.pluginManager.getUIExtension("root", rootExtensionNames[i]);
            if (rootExtension == null) continue;
            this.richTextEditor.getContainer().add((Widget)rootExtension.getUIObject(rootExtensionNames[i]));
        }
    }

    protected void fillMenu() {
        String[] entries = this.config.getParameter(MENU_ROLE, "").split(WHITE_SPACE_SEPARATOR);
        for (int i = 0; i < entries.length; ++i) {
            UIExtension uie = this.pluginManager.getUIExtension(MENU_ROLE, entries[i]);
            if (uie == null) continue;
            this.richTextEditor.getMenu().addItem((MenuItem)uie.getUIObject(entries[i]));
        }
    }

    protected void initTextArea() {
        this.richTextEditor.getTextArea().setFocus(true);
        if (!this.richTextEditor.getTextArea().isEnabled()) {
            this.richTextEditor.getTextArea().getCommandManager().execute(new Command("enable"), true);
        }
        this.richTextEditor.getTextArea().getCommandManager().execute(SUBMIT);
    }

    public void update() {
        this.toolBarController.update(this.richTextEditor.getTextArea(), this.syntaxValidator);
    }

    public boolean canUpdate() {
        return this.richTextEditor.getTextArea().isAttached() && this.richTextEditor.getTextArea().isEnabled();
    }

    public RichTextEditor getRichTextEditor() {
        return this.richTextEditor;
    }

    public Config getConfig() {
        return this.config;
    }

    protected void saveRegistration(HandlerRegistration registration) {
        this.registrations.add((Object)registration);
    }

    public void destroy() {
        this.toolBarController.destroy();
        this.pluginManager.unloadAll();
        this.registrations.removeHandlers();
        this.richTextEditor.getTextArea().getCommandManager().removeCommandListener((CommandListener)this);
        this.richTextEditor.removeFromParent();
    }
}

