/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.indent.exec;

import com.google.gwt.dom.client.Node;
import java.util.ArrayList;
import org.xwiki.gwt.dom.client.DOMUtils;
import org.xwiki.gwt.dom.client.Document;
import org.xwiki.gwt.dom.client.DocumentFragment;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.wysiwyg.client.plugin.indent.exec.AbstractListExecutable;

public class OutdentExecutable
extends AbstractListExecutable {
    protected static final String LINE_BREAK_TAG = "br";

    public OutdentExecutable(RichTextArea rta) {
        super(rta);
    }

    protected boolean canExecute(Element listItem) {
        if (!super.canExecute(listItem)) {
            return false;
        }
        return listItem.getParentNode() != null;
    }

    protected void execute(Element listItem) {
        Element parentList = (Element)listItem.getParentNode();
        Element parentListItem = (Element)parentList.getParentNode();
        if (parentListItem != null && parentListItem.getNodeName().equalsIgnoreCase("li")) {
            this.outdentItem(listItem, parentList, parentListItem);
        } else {
            this.outdentFirstLevelItem(listItem, parentList);
        }
    }

    protected boolean executeOnMultipleItems(Range range, boolean perform) {
        ArrayList<Element> toOutdent = new ArrayList<Element>();
        boolean outdentResult = false;
        Node rangeLeaf = this.domUtils.getFirstLeaf(range);
        Node lastLeaf = this.domUtils.getLastLeaf(range);
        Element lastProcessed = null;
        while (rangeLeaf != null) {
            Element currentLi = (Element)this.domUtils.getFirstAncestor(rangeLeaf, new String[]{"li"});
            if (lastProcessed == null || currentLi != null && !lastProcessed.isOrHasChild((Node)currentLi)) {
                boolean canOutdent = this.canExecute(currentLi);
                if (canOutdent && perform) {
                    toOutdent.add(currentLi);
                }
                outdentResult = canOutdent || outdentResult;
                lastProcessed = currentLi;
            }
            rangeLeaf = this.getNextLeafBefore(rangeLeaf, lastLeaf);
        }
        if (perform) {
            for (Element listItem : toOutdent) {
                this.execute(listItem);
            }
        }
        return outdentResult;
    }

    private Node getNextLeafBefore(Node currentLeaf, Node lastLeaf) {
        if (currentLeaf == lastLeaf) {
            return null;
        }
        return this.domUtils.getNextLeaf(currentLeaf);
    }

    public void outdentItem(Element listItem, Element parentList, Element parentListItem) {
        this.domUtils.splitNode(parentListItem.getParentNode(), (Node)parentList, this.domUtils.getNodeIndex((Node)listItem));
        Element newListItem = (Element)parentListItem.getNextSibling();
        if (!parentList.hasChildNodes()) {
            if (parentList.getPreviousSibling().getNodeName().equalsIgnoreCase(LINE_BREAK_TAG)) {
                parentListItem.removeChild(parentList.getPreviousSibling());
            }
            parentListItem.removeChild((Node)parentList);
        }
        Element newParentList = (Element)listItem.getParentNode();
        newListItem.getParentNode().replaceChild((Node)listItem, (Node)newListItem);
        DocumentFragment newListItemChildren = newListItem.extractContents();
        listItem.appendChild((Node)newListItemChildren);
        if (!newParentList.hasChildNodes()) {
            newParentList.getParentNode().removeChild((Node)newParentList);
        } else {
            Node previousNewListSibling = newParentList.getPreviousSibling();
            if (previousNewListSibling != null && this.isList(previousNewListSibling)) {
                while (newParentList.getFirstChild() != null) {
                    previousNewListSibling.appendChild(newParentList.getFirstChild());
                }
                newParentList.getParentNode().removeChild((Node)newParentList);
            }
        }
    }

    protected void outdentFirstLevelItem(Element listItem, Element parentList) {
        Element newList = (Element)this.domUtils.splitNode((Node)parentList, this.domUtils.getNodeIndex((Node)listItem));
        newList.removeChild((Node)listItem);
        this.domUtils.insertAfter((Node)this.extractFirstLevelListItem(listItem), (Node)parentList);
        if (!parentList.hasChildNodes()) {
            parentList.getParentNode().removeChild((Node)parentList);
        }
        if (!newList.hasChildNodes()) {
            newList.getParentNode().removeChild((Node)newList);
        } else {
            Node previousNewListSibling = newList.getPreviousSibling();
            if (previousNewListSibling != null && this.isList(previousNewListSibling)) {
                while (newList.getFirstChild() != null) {
                    previousNewListSibling.appendChild(newList.getFirstChild());
                }
                newList.getParentNode().removeChild((Node)newList);
            }
        }
    }

    private DocumentFragment extractFirstLevelListItem(Element listItem) {
        DocumentFragment extractedLi = ((Document)listItem.getOwnerDocument()).createDocumentFragment();
        Element wrappingP = null;
        while (listItem.hasChildNodes()) {
            Node currentChild = listItem.getFirstChild();
            if (!DOMUtils.getInstance().isBlock(currentChild)) {
                if (wrappingP == null) {
                    wrappingP = (Element)listItem.getOwnerDocument().createPElement().cast();
                }
                wrappingP.appendChild(currentChild);
                continue;
            }
            if (wrappingP != null) {
                extractedLi.appendChild(wrappingP);
            }
            extractedLi.appendChild(currentChild);
            wrappingP = null;
        }
        if (wrappingP != null) {
            extractedLi.appendChild(wrappingP);
        }
        return extractedLi;
    }
}

