/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.Node;
import org.xwiki.gwt.dom.client.DocumentFragment;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.user.client.EscapeUtils;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.AbstractInsertElementExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfigDOMReader;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkConfigDOMReader
implements AbstractInsertElementExecutable.ConfigDOMReader<LinkConfig, AnchorElement> {
    private final ImageConfigDOMReader imageConfigHTMLParser = new ImageConfigDOMReader();

    public LinkConfig read(AnchorElement anchor) {
        LinkConfig linkConfig = new LinkConfig();
        DocumentFragment linkMetadata = Element.as((Node)anchor).getMetaData();
        if (linkMetadata != null) {
            String startComment = linkMetadata.getChildNodes().getItem(0).getNodeValue();
            Element wrappingSpan = (Element)linkMetadata.getChildNodes().getItem(1);
            linkConfig.setReference(EscapeUtils.unescapeBackslash((String)startComment.substring("startwikilink:".length())));
            linkConfig.setType(this.readLinkType(wrappingSpan, linkConfig.getReference()));
        } else {
            linkConfig.setType(LinkConfig.LinkType.EXTERNAL);
        }
        linkConfig.setUrl(anchor.getAttribute("href"));
        linkConfig.setLabel(anchor.getInnerHTML());
        if (anchor.getChildNodes().getLength() == 1 && "img".equalsIgnoreCase(anchor.getFirstChild().getNodeName())) {
            ImageElement image = (ImageElement)anchor.getFirstChild();
            linkConfig.setLabelText(this.imageConfigHTMLParser.read(image).getReference());
            linkConfig.setReadOnlyLabel(true);
        } else {
            linkConfig.setLabelText(anchor.getInnerText());
        }
        linkConfig.setTooltip(anchor.getTitle());
        linkConfig.setOpenInNewWindow("__blank".equals(anchor.getRel()));
        return linkConfig;
    }

    private LinkConfig.LinkType readLinkType(Element wrappingSpan, String reference) {
        String wrappingSpanClass = wrappingSpan.getClassName();
        if ("wikilink".equals(wrappingSpanClass)) {
            return LinkConfig.LinkType.WIKIPAGE;
        }
        if ("wikicreatelink".equals(wrappingSpanClass)) {
            return LinkConfig.LinkType.NEW_WIKIPAGE;
        }
        if ("wikiexternallink".equals(wrappingSpanClass)) {
            if (reference.startsWith("mailto")) {
                return LinkConfig.LinkType.EMAIL;
            }
            if (reference.startsWith("attach")) {
                return LinkConfig.LinkType.ATTACHMENT;
            }
        }
        return LinkConfig.LinkType.EXTERNAL;
    }
}

