/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.gwt.user.client.HandlerRegistrationCollection;
import org.xwiki.gwt.wysiwyg.client.Messages;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.FocusWidgetUIExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroPlugin;

public class MacroToolBarExtension
implements ClickHandler {
    private static final String TOOLBAR_ROLE = "toolbar";
    private static final String MACRO_NAMESPACE = "macro:";
    private final MacroPlugin plugin;
    private final Map<PushButton, String> macroIds = new HashMap<PushButton, String>();
    private final HandlerRegistrationCollection registrations = new HandlerRegistrationCollection();
    private final FocusWidgetUIExtension toolBarExtension = new FocusWidgetUIExtension("toolbar");

    public MacroToolBarExtension(MacroPlugin plugin) {
        this.plugin = plugin;
        List<String> toolBarFeatureNames = Arrays.asList(plugin.getConfig().getParameter(TOOLBAR_ROLE, "").split("\\s+"));
        for (String featureName : toolBarFeatureNames) {
            if (!featureName.startsWith(MACRO_NAMESPACE)) continue;
            this.addToolBarButtonToInsertMacro(featureName.substring(MACRO_NAMESPACE.length()));
        }
    }

    private void addToolBarButtonToInsertMacro(String macroId) {
        if (this.plugin.getTextArea().getCommandManager().isSupported(MacroPlugin.INSERT)) {
            PushButton button = new PushButton();
            this.registrations.add((Object)button.addClickHandler((ClickHandler)this));
            button.setTitle(Messages.INSTANCE.macroInsertTooltip(macroId));
            button.addStyleName("xMacroButton");
            button.addStyleName("macro-" + macroId);
            this.toolBarExtension.addFeature(MACRO_NAMESPACE + macroId, (UIObject)button);
            this.macroIds.put(button, macroId);
        }
    }

    public void destroy() {
        this.registrations.removeHandlers();
        for (PushButton button : this.macroIds.keySet()) {
            button.removeFromParent();
        }
        this.macroIds.clear();
        this.toolBarExtension.clearFeatures();
    }

    public FocusWidgetUIExtension getExtension() {
        return this.toolBarExtension;
    }

    public void onClick(ClickEvent event) {
        Widget sender = (Widget)event.getSource();
        String macroId = this.macroIds.get(sender);
        if (macroId != null) {
            this.plugin.insert(macroId);
        }
    }
}

