/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.configuration.RenderingConfiguration;
import org.xwiki.rendering.transformation.Transformation;

@Component
@Singleton
public class DefaultRenderingConfiguration
implements RenderingConfiguration,
Initializable {
    @Inject
    private List<Transformation> transformations = new ArrayList<Transformation>();
    private String linkLabelFormat = "%p";
    private Properties interWikiDefinitions = new Properties();

    public void initialize() throws InitializationException {
        Collections.sort(this.transformations);
    }

    @Override
    public String getLinkLabelFormat() {
        return this.linkLabelFormat;
    }

    public void setLinkLabelFormat(String linkLabelFormat) {
        this.linkLabelFormat = linkLabelFormat;
    }

    @Override
    public Properties getInterWikiDefinitions() {
        return this.interWikiDefinitions;
    }

    public void addInterWikiDefinition(String interWikiAlias, String interWikiURL) {
        this.interWikiDefinitions.setProperty(interWikiAlias, interWikiURL);
    }

    public void setTransformations(List<Transformation> transformations) {
        this.transformations = transformations;
    }

    @Override
    public List<Transformation> getTransformations() {
        return this.transformations;
    }
}

