/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.renderer.printer;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.renderer.printer.XMLWikiPrinter;

public class XHTMLWikiPrinter
extends XMLWikiPrinter {
    private int spaceCount = 0;
    private boolean isInCData;
    private boolean isInPreserveElement;
    private boolean elementEnded;
    private boolean hasTextBeenPrinted;

    public XHTMLWikiPrinter(WikiPrinter printer) {
        super(printer);
    }

    @Override
    public void printXML(String str) {
        this.handleSpaceWhenInText();
        super.printXML(str);
        this.hasTextBeenPrinted = true;
    }

    @Override
    public void printXMLElement(String name) {
        this.handleSpaceWhenStartElement();
        super.printXMLElement(name);
    }

    @Override
    public void printXMLElement(String name, String[][] attributes) {
        this.handleSpaceWhenStartElement();
        super.printXMLElement(name, attributes);
    }

    @Override
    public void printXMLElement(String name, Map<String, String> attributes) {
        this.handleSpaceWhenStartElement();
        super.printXMLElement(name, attributes);
    }

    @Override
    public void printXMLStartElement(String name) {
        this.handleSpaceWhenStartElement();
        super.printXMLStartElement(name);
    }

    @Override
    public void printXMLStartElement(String name, String[][] attributes) {
        this.handleSpaceWhenStartElement();
        super.printXMLStartElement(name, attributes);
    }

    @Override
    public void printXMLStartElement(String name, Map<String, String> attributes) {
        this.handleSpaceWhenStartElement();
        super.printXMLStartElement(name, attributes);
    }

    @Override
    public void printXMLStartElement(String name, Attributes attributes) {
        this.handleSpaceWhenStartElement();
        super.printXMLStartElement(name, attributes);
    }

    @Override
    public void printXMLEndElement(String name) {
        this.handleSpaceWhenEndlement();
        super.printXMLEndElement(name);
        this.elementEnded = true;
    }

    @Override
    public void printXMLComment(String content) {
        this.printXMLComment(content, false);
    }

    @Override
    public void printXMLComment(String content, boolean escape) {
        this.handleSpaceWhenStartElement();
        super.printXMLComment(content, escape);
        this.elementEnded = true;
    }

    @Override
    public void printXMLStartCData() {
        this.handleSpaceWhenStartElement();
        super.printXMLStartCData();
    }

    @Override
    public void printXMLEndCData() {
        this.handleSpaceWhenEndlement();
        super.printXMLEndCData();
    }

    public void printSpace() {
        ++this.spaceCount;
    }

    @Override
    public void printRaw(String raw) {
        this.handleSpaceWhenStartElement();
        super.printRaw(raw);
        this.elementEnded = true;
    }

    private void handleSpaceWhenInText() {
        if (this.elementEnded || this.hasTextBeenPrinted) {
            this.handleSpaceWhenStartElement();
        } else {
            this.handleSpaceWhenEndlement();
        }
    }

    private void handleSpaceWhenStartElement() {
        if (this.spaceCount > 0) {
            if (!this.isInCData && !this.isInPreserveElement) {
                super.printXML(" ");
                for (int i = 0; i < this.spaceCount - 1; ++i) {
                    this.printEntity("&nbsp;");
                }
            } else {
                super.printXML(StringUtils.repeat((String)" ", (int)this.spaceCount));
            }
        }
        this.spaceCount = 0;
        this.elementEnded = false;
        this.hasTextBeenPrinted = false;
    }

    private void handleSpaceWhenEndlement() {
        if (!this.isInCData && !this.isInPreserveElement) {
            for (int i = 0; i < this.spaceCount; ++i) {
                this.printEntity("&nbsp;");
            }
        } else {
            super.printXML(StringUtils.repeat((String)" ", (int)this.spaceCount));
        }
        this.spaceCount = 0;
        this.elementEnded = false;
        this.hasTextBeenPrinted = false;
    }
}

