/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.reference;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.ResourceReferenceTypeParser;
import org.xwiki.rendering.wiki.WikiModel;

@Component
@Singleton
public class DefaultResourceReferenceParser
implements ResourceReferenceParser {
    public static final String TYPE_SEPARATOR = ":";
    @Inject
    private ComponentManager componentManager;

    @Override
    public ResourceReference parse(String rawReference) {
        if (!this.isInWikiMode()) {
            ResourceReference resourceReference = new ResourceReference(rawReference, ResourceType.URL);
            resourceReference.setTyped(false);
            return resourceReference;
        }
        int pos = rawReference.indexOf(TYPE_SEPARATOR);
        if (pos > -1) {
            String typePrefix = rawReference.substring(0, pos);
            String reference = rawReference.substring(pos + 1);
            try {
                ResourceReferenceTypeParser parser = (ResourceReferenceTypeParser)this.componentManager.getInstance(ResourceReferenceTypeParser.class, typePrefix);
                ResourceReference parsedResourceReference = parser.parse(reference);
                if (parsedResourceReference != null) {
                    return parsedResourceReference;
                }
            }
            catch (ComponentLookupException e) {
                // empty catch block
            }
        }
        return new ResourceReference(rawReference, ResourceType.UNKNOWN);
    }

    private boolean isInWikiMode() {
        boolean result = true;
        try {
            this.componentManager.getInstance(WikiModel.class);
        }
        catch (ComponentLookupException e) {
            result = false;
        }
        return result;
    }
}

