/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.block;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BlockFilter;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.listener.Listener;

public abstract class AbstractBlock
implements Block {
    private Map<String, String> parameters;
    private List<Block> childrenBlocks;
    private Block parentBlock;
    private Block nextSiblingBlock;
    private Block previousSiblingBlock;

    public AbstractBlock() {
    }

    public AbstractBlock(Map<String, String> parameters) {
        this.setParameters(parameters);
    }

    public AbstractBlock(Block childBlock) {
        this(childBlock, Collections.emptyMap());
    }

    public AbstractBlock(List<? extends Block> childrenBlocks) {
        this(childrenBlocks, Collections.emptyMap());
    }

    public AbstractBlock(Block childBlock, Map<String, String> parameters) {
        this(parameters);
        this.addChild(childBlock);
    }

    public AbstractBlock(List<? extends Block> childrenBlocks, Map<String, String> parameters) {
        this(parameters);
        this.addChildren(childrenBlocks);
    }

    @Override
    public void addChild(Block blockToAdd) {
        this.insertChildAfter(blockToAdd, null);
    }

    @Override
    public void addChildren(List<? extends Block> blocksToAdd) {
        if (!blocksToAdd.isEmpty()) {
            if (this.childrenBlocks == null) {
                this.childrenBlocks = new ArrayList<Block>(blocksToAdd.size());
            }
            for (Block block : blocksToAdd) {
                this.addChild(block);
            }
        }
    }

    @Override
    public void setChildren(List<? extends Block> children) {
        if (children.isEmpty()) {
            if (this.childrenBlocks != null) {
                this.childrenBlocks.clear();
            }
        } else {
            if (this.childrenBlocks != null) {
                this.childrenBlocks.clear();
            }
            this.addChildren(children);
        }
    }

    @Override
    public void setNextSiblingBlock(Block nextSiblingBlock) {
        this.nextSiblingBlock = nextSiblingBlock;
    }

    @Override
    public void setPreviousSiblingBlock(Block previousSiblingBlock) {
        this.previousSiblingBlock = previousSiblingBlock;
    }

    @Override
    public void insertChildBefore(Block blockToInsert, Block nextBlock) {
        blockToInsert.setParent(this);
        if (nextBlock == null) {
            if (this.childrenBlocks != null && !this.childrenBlocks.isEmpty()) {
                Block lastBlock = this.childrenBlocks.get(this.childrenBlocks.size() - 1);
                blockToInsert.setPreviousSiblingBlock(lastBlock);
                lastBlock.setNextSiblingBlock(blockToInsert);
            } else {
                blockToInsert.setPreviousSiblingBlock(null);
                if (this.childrenBlocks == null) {
                    this.childrenBlocks = new ArrayList<Block>(1);
                }
            }
            blockToInsert.setNextSiblingBlock(null);
            this.childrenBlocks.add(blockToInsert);
        } else {
            Block previousBlock = nextBlock.getPreviousSibling();
            if (previousBlock != null) {
                previousBlock.setNextSiblingBlock(blockToInsert);
                blockToInsert.setPreviousSiblingBlock(previousBlock);
            } else {
                blockToInsert.setPreviousSiblingBlock(null);
            }
            blockToInsert.setNextSiblingBlock(nextBlock);
            nextBlock.setPreviousSiblingBlock(blockToInsert);
            if (this.childrenBlocks == null || this.childrenBlocks.isEmpty()) {
                this.childrenBlocks = new ArrayList<Block>(1);
                this.childrenBlocks.add(blockToInsert);
            } else {
                this.childrenBlocks.add(this.indexOfChild(nextBlock), blockToInsert);
            }
        }
    }

    @Override
    public void insertChildAfter(Block blockToInsert, Block previousBlock) {
        if (previousBlock == null) {
            this.insertChildBefore(blockToInsert, null);
        } else {
            Block nextBlock = previousBlock.getNextSibling();
            if (nextBlock != null) {
                nextBlock.setPreviousSiblingBlock(blockToInsert);
                blockToInsert.setNextSiblingBlock(nextBlock);
            } else {
                blockToInsert.setNextSiblingBlock(null);
            }
            blockToInsert.setPreviousSiblingBlock(previousBlock);
            previousBlock.setNextSiblingBlock(blockToInsert);
            if (this.childrenBlocks == null) {
                this.childrenBlocks = new ArrayList<Block>(1);
            }
            this.childrenBlocks.add(this.indexOfChild(previousBlock) + 1, blockToInsert);
        }
    }

    @Override
    public void replaceChild(Block newBlock, Block oldBlock) {
        this.replaceChild(Collections.singletonList(newBlock), oldBlock);
    }

    @Override
    public void replaceChild(List<Block> newBlocks, Block oldBlock) {
        int position = this.indexOfChild(oldBlock);
        if (position == -1) {
            throw new InvalidParameterException("Provided Block to replace is not a child");
        }
        List<Block> blocks = this.getChildren();
        blocks.remove(position);
        oldBlock.setParent(null);
        Block previousBlock = oldBlock.getPreviousSibling();
        if (newBlocks.isEmpty()) {
            previousBlock.setNextSiblingBlock(oldBlock.getNextSibling());
        }
        Block lastBlock = null;
        for (Block block : newBlocks) {
            block.setParent(this);
            block.setPreviousSiblingBlock(previousBlock);
            if (previousBlock != null) {
                previousBlock.setNextSiblingBlock(block);
            }
            previousBlock = block;
            lastBlock = block;
        }
        Block nextBlock = oldBlock.getNextSibling();
        if (nextBlock != null) {
            nextBlock.setPreviousSiblingBlock(lastBlock);
        }
        if (lastBlock != null) {
            lastBlock.setNextSiblingBlock(nextBlock);
        }
        blocks.addAll(position, newBlocks);
        oldBlock.setNextSiblingBlock(null);
        oldBlock.setPreviousSiblingBlock(null);
    }

    private int indexOfChild(Block block) {
        return this.indexOfBlock(block, this.getChildren());
    }

    private int indexOfBlock(Block block, List<Block> blocks) {
        int position = 0;
        for (Block child : blocks) {
            if (child == block) {
                return position;
            }
            ++position;
        }
        return -1;
    }

    @Override
    public List<Block> getChildren() {
        return this.childrenBlocks == null ? Collections.emptyList() : this.childrenBlocks;
    }

    @Override
    public Block getParent() {
        return this.parentBlock;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public String getParameter(String name) {
        return this.parameters == null ? null : this.parameters.get(name);
    }

    @Override
    public void setParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, String>(1);
        }
        this.parameters.put(name, value);
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, String>(parameters);
        } else {
            this.parameters.clear();
            this.parameters.putAll(parameters);
        }
    }

    @Override
    public void setParent(Block parentBlock) {
        this.parentBlock = parentBlock;
    }

    @Override
    public Block getRoot() {
        Block block = this;
        while (block.getParent() != null) {
            block = block.getParent();
        }
        return block;
    }

    @Override
    public Block getNextSibling() {
        return this.nextSiblingBlock;
    }

    @Override
    public Block getPreviousSibling() {
        return this.previousSiblingBlock;
    }

    @Override
    public void removeBlock(Block childBlockToRemove) {
        this.getChildren().remove(childBlockToRemove);
        if (childBlockToRemove != null) {
            Block nextBlock;
            Block previousBlock = childBlockToRemove.getPreviousSibling();
            if (previousBlock != null) {
                previousBlock.setNextSiblingBlock(childBlockToRemove.getNextSibling());
            }
            if ((nextBlock = childBlockToRemove.getNextSibling()) != null) {
                nextBlock.setPreviousSiblingBlock(previousBlock);
            }
            childBlockToRemove.setNextSiblingBlock(null);
            childBlockToRemove.setPreviousSiblingBlock(null);
        }
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    @Override
    public Block clone() {
        return this.clone(null);
    }

    @Override
    public Block clone(BlockFilter blockFilter) {
        AbstractBlock block;
        try {
            block = (AbstractBlock)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone object", e);
        }
        if (this.parameters != null) {
            block.parameters = new LinkedHashMap<String, String>(this.parameters);
        }
        if (this.childrenBlocks != null) {
            block.childrenBlocks = new ArrayList<Block>(this.childrenBlocks.size());
            for (Block childBlock : this.childrenBlocks) {
                if (blockFilter != null) {
                    Block clonedChildBlocks = childBlock.clone(blockFilter);
                    List<Block> filteredBlocks = blockFilter.filter(clonedChildBlocks);
                    if (filteredBlocks.size() == 0) {
                        filteredBlocks = clonedChildBlocks.getChildren();
                    }
                    block.addChildren(filteredBlocks);
                    continue;
                }
                block.addChild(childBlock.clone());
            }
        }
        return block;
    }

    @Override
    public void traverse(Listener listener) {
        this.before(listener);
        for (Block block : this.getChildren()) {
            block.traverse(listener);
        }
        this.after(listener);
    }

    public void before(Listener listener) {
    }

    public void after(Listener listener) {
    }

    @Override
    public <T extends Block> List<T> getBlocks(BlockMatcher matcher, Block.Axes axes) {
        List<T> blocks = null;
        blocks = axes == Block.Axes.SELF ? this.addBlock(this, matcher, blocks) : (axes.compareTo(Block.Axes.ANCESTOR_OR_SELF) <= 0 ? this.getAncestorBlocks(matcher, axes) : (axes.compareTo(Block.Axes.DESCENDANT_OR_SELF) <= 0 ? this.getDescendantBlocks(matcher, axes) : this.getSiblingBlocks(matcher, axes)));
        return blocks != null ? blocks : Collections.emptyList();
    }

    private <T extends Block> List<T> getAncestorBlocks(BlockMatcher matcher, Block.Axes axes) {
        List<Object> blocks = null;
        Block nextBlock = this.getParent();
        Block.Axes nextAxes = axes;
        switch (axes) {
            case ANCESTOR_OR_SELF: {
                blocks = this.addBlock(this, matcher, blocks);
                break;
            }
            case ANCESTOR: {
                nextAxes = Block.Axes.ANCESTOR_OR_SELF;
                break;
            }
            case PARENT: {
                nextAxes = Block.Axes.SELF;
                break;
            }
        }
        if (nextBlock != null) {
            blocks = this.getBlocks(nextBlock, matcher, nextAxes, blocks);
        }
        return blocks != null ? blocks : Collections.emptyList();
    }

    private <T extends Block> List<T> getDescendantBlocks(BlockMatcher matcher, Block.Axes axes) {
        List<Object> blocks = null;
        Block nextBlock = null;
        Block.Axes nextAxes = axes;
        switch (axes) {
            case CHILD: {
                if (this.getChildren().isEmpty()) break;
                nextBlock = this.getChildren().get(0);
                nextAxes = Block.Axes.FOLLOWING_SIBLING;
                blocks = this.addBlock(nextBlock, matcher, blocks);
                break;
            }
            case DESCENDANT_OR_SELF: {
                blocks = this.addBlock(this, matcher, blocks);
                blocks = this.getBlocks((T)((Object)this.getChildren()), matcher, Block.Axes.DESCENDANT_OR_SELF, (List<T>)blocks);
                break;
            }
            case DESCENDANT: {
                blocks = this.getBlocks((T)((Object)this.getChildren()), matcher, Block.Axes.DESCENDANT_OR_SELF, (List<T>)blocks);
                break;
            }
        }
        if (nextBlock != null) {
            blocks = this.getBlocks(nextBlock, matcher, nextAxes, blocks);
        }
        return blocks != null ? blocks : Collections.emptyList();
    }

    private <T extends Block> List<T> getSiblingBlocks(BlockMatcher matcher, Block.Axes axes) {
        List<Object> blocks = null;
        Block nextBlock = null;
        Block.Axes nextAxes = axes;
        switch (axes) {
            case FOLLOWING_SIBLING: {
                nextBlock = this.getNextSibling();
                blocks = this.addBlock(nextBlock, matcher, blocks);
                break;
            }
            case FOLLOWING: {
                for (Block nextSibling = this.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
                    blocks = this.getBlocks(nextSibling, matcher, Block.Axes.DESCENDANT_OR_SELF, blocks);
                }
                break;
            }
            case PRECEDING_SIBLING: {
                nextBlock = this.getPreviousSibling();
                blocks = this.addBlock(nextBlock, matcher, blocks);
                break;
            }
            case PRECEDING: {
                for (Block previousSibling = this.getPreviousSibling(); previousSibling != null; previousSibling = previousSibling.getPreviousSibling()) {
                    blocks = this.getBlocks(previousSibling, matcher, Block.Axes.DESCENDANT_OR_SELF, blocks);
                }
                break;
            }
        }
        if (nextBlock != null) {
            blocks = this.getBlocks(nextBlock, matcher, nextAxes, blocks);
        }
        return blocks != null ? blocks : Collections.emptyList();
    }

    private <T extends Block> List<T> addBlock(Block block, BlockMatcher matcher, List<T> blocks) {
        List<T> newBlocks = blocks;
        if (block != null && matcher.match(block)) {
            if (newBlocks == null) {
                newBlocks = new ArrayList<T>();
            }
            newBlocks.add(block);
        }
        return newBlocks;
    }

    private <T extends Block> List<T> getBlocks(List<T> blocks, BlockMatcher matcher, Block.Axes axes, List<T> blocksOut) {
        List<Object> newBlocks = blocksOut;
        for (Block child : blocks) {
            newBlocks = this.getBlocks(child, matcher, axes, newBlocks);
        }
        return newBlocks;
    }

    private <T extends Block> List<T> getBlocks(T block, BlockMatcher matcher, Block.Axes axes, List<T> blocksOut) {
        List<T> newBlocks = blocksOut;
        List nextBlocks = block.getBlocks(matcher, axes);
        if (!nextBlocks.isEmpty()) {
            if (newBlocks == null) {
                newBlocks = nextBlocks;
            } else {
                newBlocks.addAll(nextBlocks);
            }
        }
        return newBlocks;
    }

    @Override
    public <T extends Block> T getFirstBlock(BlockMatcher matcher, Block.Axes axes) {
        Block block = null;
        if (axes == Block.Axes.SELF) {
            if (matcher.match(this)) {
                block = this;
            }
        } else {
            block = axes.compareTo(Block.Axes.ANCESTOR_OR_SELF) <= 0 ? this.getFirstAncestorBlock(matcher, axes) : (axes.compareTo(Block.Axes.DESCENDANT_OR_SELF) <= 0 ? this.getFirstDescendantBlock(matcher, axes) : (axes.compareTo(Block.Axes.FOLLOWING_SIBLING) <= 0 ? this.getFirstFollowingSiblingBlock(matcher, axes) : this.getFirstPrecedingSiblingBlock(matcher, axes)));
        }
        return (T)block;
    }

    private Block getFirstAncestorBlock(BlockMatcher matcher, Block.Axes axes) {
        Block nextBlock = null;
        Block.Axes nextAxes = axes;
        switch (axes) {
            case ANCESTOR_OR_SELF: {
                if (matcher.match(this)) {
                    return this;
                }
            }
            case ANCESTOR: 
            case PARENT: {
                nextAxes = axes == Block.Axes.PARENT ? Block.Axes.SELF : Block.Axes.ANCESTOR_OR_SELF;
                nextBlock = this.getParent();
                break;
            }
        }
        return nextBlock != null ? (Block)nextBlock.getFirstBlock(matcher, nextAxes) : null;
    }

    private Block getFirstDescendantBlock(BlockMatcher matcher, Block.Axes axes) {
        Block nextBlock = null;
        Block.Axes nextAxes = axes;
        switch (axes) {
            case CHILD: {
                if (this.getChildren().isEmpty()) break;
                nextBlock = this.childrenBlocks.get(0);
                nextAxes = Block.Axes.FOLLOWING_SIBLING;
                if (!matcher.match(nextBlock)) break;
                return nextBlock;
            }
            case DESCENDANT_OR_SELF: {
                if (matcher.match(this)) {
                    return this;
                }
            }
            case DESCENDANT: {
                for (Block child : this.getChildren()) {
                    Object matchedBlock = child.getFirstBlock(matcher, Block.Axes.DESCENDANT_OR_SELF);
                    if (matchedBlock == null) continue;
                    return matchedBlock;
                }
                break;
            }
        }
        return nextBlock != null ? (Block)nextBlock.getFirstBlock(matcher, nextAxes) : null;
    }

    private Block getFirstFollowingSiblingBlock(BlockMatcher matcher, Block.Axes axes) {
        Block nextBlock = null;
        Block.Axes nextAxes = axes;
        switch (axes) {
            case FOLLOWING_SIBLING: {
                nextBlock = this.getNextSibling();
                if (nextBlock == null || !matcher.match(nextBlock)) break;
                return nextBlock;
            }
            case FOLLOWING: {
                for (Block nextSibling = this.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
                    Object matchedBlock = nextSibling.getFirstBlock(matcher, Block.Axes.DESCENDANT_OR_SELF);
                    if (matchedBlock == null) continue;
                    return matchedBlock;
                }
                break;
            }
        }
        return nextBlock != null ? (Block)nextBlock.getFirstBlock(matcher, nextAxes) : null;
    }

    private Block getFirstPrecedingSiblingBlock(BlockMatcher matcher, Block.Axes axes) {
        Block nextBlock = null;
        Block.Axes nextAxes = axes;
        switch (axes) {
            case PRECEDING_SIBLING: {
                nextBlock = this.getPreviousSibling();
                if (nextBlock == null || !matcher.match(nextBlock)) break;
                return nextBlock;
            }
            case PRECEDING: {
                for (Block previousSibling = this.getPreviousSibling(); previousSibling != null; previousSibling = previousSibling.getPreviousSibling()) {
                    Object matchedBlock = previousSibling.getFirstBlock(matcher, Block.Axes.DESCENDANT_OR_SELF);
                    if (matchedBlock == null) continue;
                    return matchedBlock;
                }
                break;
            }
        }
        return nextBlock != null ? (Block)nextBlock.getFirstBlock(matcher, nextAxes) : null;
    }
}

