/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;

@Component
@Singleton
public class DefaultRenderingContext
implements MutableRenderingContext {
    private static final String EXECUTION_CONTEXT_KEY = "rendering.context";
    private static final Context NULL_CONTEXT = new Context();
    @Inject
    private Execution execution;

    @Override
    public void push(Transformation transformation, TransformationContext context) {
        this.push(transformation, context.getXDOM(), context.getSyntax(), context.getId(), context.isRestricted(), context.getTargetSyntax());
    }

    @Override
    public void push(Transformation transformation, XDOM xdom, Syntax syntax, String id, boolean restricted, Syntax targetSyntax) {
        Deque<Context> stack = this.getContextstack(true);
        if (stack != null) {
            stack.push(new Context(transformation, xdom, syntax, id, restricted, targetSyntax));
        }
    }

    @Override
    public void pop() {
        Deque<Context> stack = this.getContextstack(false);
        if (stack != null) {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transformInContext(Transformation transformation, TransformationContext context, Block block) throws TransformationException {
        try {
            this.push(transformation, context);
            transformation.transform(block, context);
        }
        finally {
            this.pop();
        }
    }

    private Deque<Context> getContextstack(boolean create) {
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            ArrayDeque stack = (ArrayDeque)context.getProperty(EXECUTION_CONTEXT_KEY);
            if (stack == null && create) {
                stack = new ArrayDeque();
                context.setProperty(EXECUTION_CONTEXT_KEY, stack);
            }
            return stack;
        }
        return null;
    }

    protected Context peek() {
        Deque<Context> stack = this.getContextstack(false);
        return stack != null && !stack.isEmpty() ? stack.peek() : NULL_CONTEXT;
    }

    @Override
    public XDOM getXDOM() {
        return this.peek().xdom;
    }

    @Override
    public Block getCurrentBlock() {
        return this.peek().currentBlock;
    }

    @Override
    public void setCurrentBlock(Block block) {
        Context context = this.peek();
        if (context != null && context != NULL_CONTEXT) {
            context.currentBlock = block;
        }
    }

    @Override
    public Syntax getDefaultSyntax() {
        return this.peek().syntax;
    }

    @Override
    public boolean isRestricted() {
        return this.peek().restricted;
    }

    @Override
    public Transformation getTransformation() {
        return this.peek().transformation;
    }

    @Override
    public String getTransformationId() {
        return this.peek().transformationId;
    }

    @Override
    public Syntax getTargetSyntax() {
        return this.peek().targetSyntax;
    }

    protected static final class Context
    implements Cloneable {
        private final XDOM xdom;
        private Block currentBlock;
        private final Syntax syntax;
        private final boolean restricted;
        private final Transformation transformation;
        private final String transformationId;
        private final Syntax targetSyntax;

        private Context() {
            this(null, null, null, null, false, null);
        }

        private Context(Transformation transformation, XDOM xdom, Syntax syntax, String transformationId, boolean restricted, Syntax targetSyntax) {
            this.transformationId = transformationId;
            this.xdom = xdom;
            this.syntax = syntax;
            this.restricted = restricted;
            this.transformation = transformation;
            this.targetSyntax = targetSyntax;
        }

        public String getTransformationId() {
            return this.transformationId;
        }

        public Context clone() {
            Context newContext;
            try {
                newContext = (Context)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Failed to clone object", e);
            }
            return newContext;
        }
    }
}

