/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.content;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.content.ContentMacroParameters;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="content")
@Singleton
public class ContentMacro
extends AbstractMacro<ContentMacroParameters> {
    private static final String DESCRIPTION = "Allows writing content in any wiki markup";
    private static final String CONTENT_DESCRIPTION = "The content to execute";
    @Inject
    private ComponentManager componentManager;

    public ContentMacro() {
        super("Content", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), ContentMacroParameters.class);
        this.setDefaultCategory("Content");
    }

    public boolean supportsInlineMode() {
        return false;
    }

    public List<Block> execute(ContentMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        try {
            return this.getSyntaxParser(parameters.getSyntax()).parse((Reader)new StringReader(content)).getChildren();
        }
        catch (ParseException e) {
            throw new MacroExecutionException(String.format("Failed to parse macro content in syntax [%s]", parameters.getSyntax()), (Throwable)e);
        }
    }

    protected Parser getSyntaxParser(Syntax syntax) throws MacroExecutionException {
        try {
            return (Parser)this.componentManager.getInstance(Parser.class, syntax.toIdString());
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException(String.format("Cannot find Parser for syntax [%s]", syntax.toIdString()));
        }
    }
}

