/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.ctsreport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.macro.ctsreport.Result;
import org.xwiki.rendering.internal.macro.ctsreport.ResultExtractor;
import org.xwiki.rendering.internal.macro.ctsreport.Test;
import org.xwiki.rendering.internal.macro.ctsreport.TestParser;
import org.xwiki.rendering.macro.AbstractNoParameterMacro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="ctsdata")
@Singleton
public class CTSDataMacro
extends AbstractNoParameterMacro {
    private static final String DESCRIPTION = "Parses XWiki Rendering Compatibility Test Suite (CTS) JUnit Results";
    private static final String CONTENT_DESCRIPTION = "Textual results of CTS execution, one result per line";
    @Inject
    private Logger logger;
    @Inject
    private Execution execution;
    @Inject
    private MacroContentParser contentParser;
    @Inject
    @Named(value="plain/1.0")
    private BlockRenderer plainTextRenderer;

    public CTSDataMacro() {
        super("CTS Data", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION));
        this.setDefaultCategory("Development");
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(Object unusedParameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM xdom = this.contentParser.parse(content, context, true, false);
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        this.plainTextRenderer.render((Block)xdom, (WikiPrinter)printer);
        String parsedContent = printer.toString();
        TestParser parser = new TestParser();
        ArrayList<Result> results = new ArrayList<Result>();
        for (String resultLine : parsedContent.split("[\\r\\n]+")) {
            results.add(parser.parse(resultLine));
        }
        ScriptContext scriptContext = this.getScriptContext();
        if (scriptContext != null) {
            ResultExtractor extractor = new ResultExtractor();
            Set<String> testNames = extractor.extractByTestName(results);
            scriptContext.setAttribute("ctsTestNames", testNames, 100);
            Map<String, Pair<Set<Test>, Set<Test>>> tests = extractor.extractBySyntax(results);
            extractor.normalize(testNames, tests);
            scriptContext.setAttribute("ctsTests", tests, 100);
        } else {
            this.logger.warn("Script Context not found in the Execution Context. CTS Data variable not bound!");
        }
        return Collections.emptyList();
    }

    private ScriptContext getScriptContext() {
        return (ScriptContext)this.execution.getContext().getProperty("scriptContext");
    }
}

