/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.jira;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.jira.JIRADataSource;
import org.xwiki.rendering.macro.jira.JIRADisplayer;
import org.xwiki.rendering.macro.jira.JIRAMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="jira")
@Singleton
public class JIRAMacro
extends AbstractMacro<JIRAMacroParameters> {
    private static final String DESCRIPTION = "Fetches information from a JIRA server and displays them as a table, list or enumeration.";
    private static final String CONTENT_DESCRIPTION = "The JIRA issues to retrieve";
    @Inject
    private ComponentManager componentManager;

    public JIRAMacro() {
        super("JIRA", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), JIRAMacroParameters.class);
        this.setDefaultCategory("Content");
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(JIRAMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        return this.getDisplayer(parameters).display(this.getDataSource(parameters).getData(content, parameters), parameters);
    }

    private JIRADataSource getDataSource(JIRAMacroParameters parameters) throws MacroExecutionException {
        JIRADataSource source;
        try {
            source = (JIRADataSource)this.componentManager.getInstance(JIRADataSource.class, parameters.getSource());
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException(String.format("Unknown JIRA source [%s]", parameters.getSource()), (Throwable)e);
        }
        return source;
    }

    private JIRADisplayer getDisplayer(JIRAMacroParameters parameters) throws MacroExecutionException {
        JIRADisplayer displayer;
        try {
            displayer = (JIRADisplayer)this.componentManager.getInstance(JIRADisplayer.class, parameters.getStyle());
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException(String.format("Unknown JIRA style [%s]", parameters.getStyle()), (Throwable)e);
        }
        return displayer;
    }
}

