/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.internal.macro.jira.displayer.field;

import javax.inject.Named;
import javax.inject.Singleton;

import org.jdom2.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.macro.jira.JIRAFields;

/**
 * Displayer for the "type" JIRA field (displayed as an image).
 *
 * @version $Id: 4f5346099621a52beda91c98724fa3940b6c5952 $
 * @since 4.2M1
 */
@Component
@Named("type")
@Singleton
public class TypeJIRAFieldDisplayer extends AbstractImageJIRAFieldDisplayer
{
    @Override
    protected Element getElement(Element issue)
    {
        return issue.getChild(JIRAFields.TYPE);
    }

    @Override
    protected String getURL(Element issue)
    {
        return getElement(issue).getAttributeValue("iconUrl");
    }
}
