/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.toc;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.macro.toc.TocBlockFilter;
import org.xwiki.rendering.internal.macro.toc.TocTreeBuilder;
import org.xwiki.rendering.internal.macro.toc.TreeParameters;
import org.xwiki.rendering.internal.macro.toc.TreeParametersBuilder;
import org.xwiki.rendering.listener.reference.DocumentResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.toc.TocMacroParameters;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.reference.link.LinkLabelGenerator;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.wiki.WikiModel;
import org.xwiki.rendering.wiki.WikiModelException;

@Component
@Named(value="toc")
@Singleton
public class TocMacro
extends AbstractMacro<TocMacroParameters> {
    private static final String DESCRIPTION = "Generates a Table Of Contents.";
    private TocTreeBuilder tocTreeBuilder;
    @Inject
    @Named(value="plain/1.0")
    private Parser plainTextParser;
    @Inject
    private LinkLabelGenerator linkLabelGenerator;
    @Inject
    private Provider<WikiModel> wikiModelProvider;

    public TocMacro() {
        super("Table Of Contents", DESCRIPTION, TocMacroParameters.class);
        this.setPriority(2000);
        this.setDefaultCategory("Navigation");
    }

    public void initialize() throws InitializationException {
        super.initialize();
        this.tocTreeBuilder = new TocTreeBuilder(new TocBlockFilter(this.plainTextParser, this.linkLabelGenerator));
    }

    public boolean supportsInlineMode() {
        return false;
    }

    public List<Block> execute(TocMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM rootBlock = null;
        WikiModel wikiModel = (WikiModel)this.wikiModelProvider.get();
        if (parameters.getReference() != null) {
            if (wikiModel != null) {
                parameters.setScope(TocMacroParameters.Scope.PAGE);
                rootBlock = this.getXDOM((ResourceReference)new DocumentResourceReference(parameters.getReference()), wikiModel);
            } else {
                throw new MacroExecutionException("The \"reference\" parameter can only be used when a WikiModel implementation is available");
            }
        }
        TreeParametersBuilder builder = new TreeParametersBuilder();
        TreeParameters treeParameters = builder.build((Block)rootBlock, parameters, context);
        return this.tocTreeBuilder.build(treeParameters);
    }

    private XDOM getXDOM(ResourceReference reference, WikiModel wikiModel) throws MacroExecutionException {
        try {
            return wikiModel.getXDOM(reference);
        }
        catch (WikiModelException e) {
            throw new MacroExecutionException(String.format("Failed to get XDOM for [%s]", reference), (Throwable)e);
        }
    }
}

