/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml;

import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.parser.wikimodel.AbstractWikiModelParser;
import org.xwiki.rendering.internal.parser.wikimodel.XWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XHTMLXWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiCommentHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiDivisionTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiHeaderTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiImageTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiReferenceTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiSpanTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiTableDataTagHandler;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.util.IdGenerator;
import org.xwiki.shaded.wikimodel.wem.IWikiParser;
import org.xwiki.shaded.wikimodel.wem.xhtml.XhtmlParser;
import org.xwiki.shaded.wikimodel.wem.xhtml.handler.TagHandler;
import org.xwiki.xml.XMLReaderFactory;

@Component
@Named(value="xhtml/1.0")
@Singleton
public class XHTMLParser
extends AbstractWikiModelParser {
    @Inject
    @Named(value="xwiki/2.0")
    private StreamParser xwikiParser;
    @Inject
    @Named(value="link")
    private ResourceReferenceParser linkReferenceParser;
    @Inject
    @Named(value="image")
    private ResourceReferenceParser imageReferenceParser;
    @Inject
    @Named(value="xwiki/2.1")
    private PrintRendererFactory xwikiSyntaxPrintRendererFactory;
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="xhtmlmarker")
    private ResourceReferenceParser xhtmlMarkerResourceReferenceParser;
    @Inject
    @Named(value="xwiki")
    private XMLReaderFactory xmlReaderFactory;

    @Override
    public Syntax getSyntax() {
        return Syntax.XHTML_1_0;
    }

    @Override
    public StreamParser getLinkLabelParser() {
        return this.xwikiParser;
    }

    @Override
    public IWikiParser createWikiModelParser() throws ParseException {
        HashMap<String, TagHandler> handlers = new HashMap<String, TagHandler>();
        XWikiHeaderTagHandler handler = new XWikiHeaderTagHandler();
        handlers.put("h1", handler);
        handlers.put("h2", handler);
        handlers.put("h3", handler);
        handlers.put("h4", handler);
        handlers.put("h5", handler);
        handlers.put("h6", handler);
        handlers.put("a", new XWikiReferenceTagHandler(this, this.xwikiSyntaxPrintRendererFactory));
        handlers.put("img", new XWikiImageTagHandler());
        handlers.put("span", new XWikiSpanTagHandler());
        handlers.put("div", new XWikiDivisionTagHandler());
        handlers.put("th", new XWikiTableDataTagHandler());
        XhtmlParser parser = new XhtmlParser();
        parser.setExtraHandlers(handlers);
        parser.setCommentHandler(new XWikiCommentHandler(this.componentManager, this, this.xwikiSyntaxPrintRendererFactory, this.xhtmlMarkerResourceReferenceParser));
        try {
            parser.setXmlReader(this.xmlReaderFactory.createXMLReader());
        }
        catch (Exception e) {
            throw new ParseException("Failed to create XML reader", e);
        }
        return parser;
    }

    @Override
    public ResourceReferenceParser getLinkReferenceParser() {
        return this.linkReferenceParser;
    }

    @Override
    public ResourceReferenceParser getImageReferenceParser() {
        return this.imageReferenceParser;
    }

    @Override
    public XWikiGeneratorListener createXWikiGeneratorListener(Listener listener, IdGenerator idGenerator) {
        return new XHTMLXWikiGeneratorListener(this.getLinkLabelParser(), listener, this.getLinkReferenceParser(), this.getImageReferenceParser(), this.plainRendererFactory, idGenerator, this.getSyntax());
    }
}

