/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.configuration.RenderingConfiguration;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.rendering.transformation.TransformationManager;

@Component
@Singleton
public class DefaultTransformationManager
implements TransformationManager {
    @Inject
    private RenderingConfiguration configuration;
    @Inject
    private Logger logger;

    @Override
    public void performTransformations(XDOM dom, Syntax syntax) throws TransformationException {
        this.performTransformations((Block)dom, new TransformationContext(dom, syntax));
    }

    @Override
    public void performTransformations(Block block, TransformationContext context) throws TransformationException {
        boolean error = false;
        for (Transformation transformation : this.configuration.getTransformations()) {
            try {
                transformation.transform(block, context);
            }
            catch (Exception e) {
                this.logger.error("Failed to execute transformation", e);
                error = true;
            }
        }
        if (error) {
            throw new TransformationException("One or several transformations failed to execute properly. See the logs for details.");
        }
    }
}

